/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JSArray;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls2;
import java.io.ByteArrayInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class JSSaxParser
extends DefaultHandler {
    private Scope scope;
    private JSObject handler;
    private StringBuilder textBuffer = new StringBuilder();
    private static JSFunction _realParseFunction = new JSFunctionCalls2(){

        public Object call(Scope parentScope, Object handler, Object xml, Object[] extra) {
            Scope handlerScope = parentScope.child();
            handlerScope.setThis(handler);
            JSSaxParser delegateHandler = new JSSaxParser(handlerScope, (JSObject)handler);
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(delegateHandler);
                reader.setErrorHandler(delegateHandler);
                ByteArrayInputStream s = new ByteArrayInputStream(((JSString)xml).getBytes());
                reader.parse(new InputSource(s));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    };

    private JSSaxParser(Scope scope, JSObject handler) {
        this.scope = scope;
        this.handler = handler;
    }

    public static JSFunction getParser() {
        return _realParseFunction;
    }

    public void startDocument() throws SAXException {
        Object jsHandlerObj = this.handler.get("startDocument");
        if (jsHandlerObj instanceof JSFunction) {
            JSFunction jsHandlerFn = (JSFunction)jsHandlerObj;
            jsHandlerFn.call(this.scope);
        }
    }

    public void endDocument() throws SAXException {
        Object jsHandlerObj = this.handler.get("endDocument");
        if (jsHandlerObj instanceof JSFunction) {
            JSFunction jsHandlerFn = (JSFunction)jsHandlerObj;
            jsHandlerFn.call(this.scope);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        Object jsHandlerObj;
        if (this.textBuffer.length() > 0) {
            this.notifyText();
        }
        if (!((jsHandlerObj = this.handler.get("startElement")) instanceof JSFunction)) {
            return;
        }
        JSArray jsAttributes = new JSArray();
        for (int i = 0; i < attributes.getLength(); ++i) {
            JSObjectBase jsAttr = new JSObjectBase();
            jsAttr.set("localName", attributes.getLocalName(i));
            jsAttr.set("qName", attributes.getQName(i));
            jsAttr.set("uri", attributes.getURI(i));
            jsAttr.set("value", attributes.getValue(i));
            jsAttributes.add(jsAttr);
        }
        ((JSFunction)jsHandlerObj).call(this.scope, (Object)uri, (Object)localName, (Object)name, jsAttributes);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        Object jsHandlerObj;
        if (this.textBuffer.length() > 0) {
            this.notifyText();
        }
        if (!((jsHandlerObj = this.handler.get("endElement")) instanceof JSFunction)) {
            return;
        }
        ((JSFunction)jsHandlerObj).call(this.scope, (Object)uri, (Object)localName, name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.textBuffer.append(ch, start, length);
    }

    private void notifyText() {
        Object jsHandlerObj = this.handler.get("text");
        if (!(jsHandlerObj instanceof JSFunction)) {
            return;
        }
        ((JSFunction)jsHandlerObj).call(this.scope, this.textBuffer.toString());
        this.textBuffer.setLength(0);
    }

    public void warning(SAXParseException e) throws SAXException {
        Object jsHandlerObj = this.handler.get("warning");
        if (!(jsHandlerObj instanceof JSFunction)) {
            return;
        }
        ((JSFunction)jsHandlerObj).call(this.scope, (Object)e.getMessage(), (Object)e.getLineNumber(), e.getColumnNumber());
    }

    public void error(SAXParseException e) throws SAXException {
        Object jsHandlerObj = this.handler.get("error");
        if (!(jsHandlerObj instanceof JSFunction)) {
            return;
        }
        ((JSFunction)jsHandlerObj).call(this.scope, (Object)e.getMessage(), (Object)e.getLineNumber(), e.getColumnNumber());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        Object jsHandlerObj = this.handler.get("fatalError");
        if (!(jsHandlerObj instanceof JSFunction)) {
            return;
        }
        ((JSFunction)jsHandlerObj).call(this.scope, (Object)e.getMessage(), (Object)e.getLineNumber(), e.getColumnNumber());
    }
}

