/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.TestCase;
import ed.js.JSFunction;
import ed.js.JSON;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.JSBuiltInFunctions;
import ed.js.engine.Scope;
import ed.log.Logger;
import org.testng.annotations.Test;

public class JSONTest
extends TestCase {
    @Test(groups={"basic"})
    public void testJSONString() {
        String[] cases = new String[]{"abc", "'", "\\", "\"", "\\4", "a\nb", "a\rb", "a\n", "a\\"};
        Scope scope = new Scope("test scope", null);
        for (int i = 0; i < cases.length; ++i) {
            JSONTest.assertEquals((String)cases[i], (Object)scope.eval(JSON.serialize(cases[i])).toString());
            JSONTest.assertEquals((String)cases[i], (Object)scope.eval(JSON.serialize(new JSString(cases[i]))).toString());
        }
        Integer[] numbers = new Integer[]{41, -1, 292929};
        for (int i = 0; i < numbers.length; ++i) {
            JSONTest.assertEquals((Object)numbers[i], (Object)scope.eval(JSON.serialize(numbers[i])));
        }
        JSFunction blankf = (JSFunction)scope.eval("(function(){})");
        assert (scope.eval("(" + JSON.serialize(blankf) + ")") instanceof JSFunction);
        assert (scope.eval(JSON.serialize(new JSBuiltInFunctions.NewDate())) instanceof JSString);
        assert (scope.eval(JSON.serialize((Object)new JSONTest())) instanceof JSString);
        Logger log = Logger.getLogger((String)"test");
        assert (scope.eval(JSON.serialize(log)) instanceof JSString);
    }

    @Test(groups={"basic"})
    public void testJSONCycles() {
        JSObjectBase o = new JSObjectBase();
        o.set("o", o);
        boolean exception = false;
        try {
            JSON.serialize(o);
        }
        catch (Exception e) {
            exception = true;
        }
        assert (exception);
        JSObjectBase leaf = new JSObjectBase();
        JSObjectBase p = new JSObjectBase();
        p.set("o1", leaf);
        p.set("o2", leaf);
        JSON.serialize(p);
    }

    @Test(groups={"basic"})
    public void testBool() {
        JSObject foo = (JSObject)JSON.parse("{ a : true , b: false , c : 5 }");
        JSONTest.assertTrue((boolean)((Boolean)foo.get("a")));
        JSONTest.assertFalse((boolean)((Boolean)foo.get("b")));
        JSONTest.assertEquals((Object)5, (Object)((Number)foo.get("c")));
    }

    public static void main(String[] args) {
        new JSONTest().runConsole();
    }
}

