/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JSBoolean;
import ed.js.JSDate;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls2;
import ed.util.StringParseUtil;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSNumber
extends Number
implements JSObject {
    private Number _val;
    private static JSObjectBase _functions = new JSObjectBase();
    public static JSFunction toFixed = new JSFunctionCalls1(){

        public Object call(Scope sc, Object pointsInt, Object[] fo00000o) {
            Number n = (Number)sc.getThis();
            int num = 0;
            if (pointsInt != null && pointsInt instanceof Number) {
                num = ((Number)pointsInt).intValue();
            }
            double mult = Math.pow(10.0, num);
            long foo = Math.round(n.doubleValue() * mult);
            double d = foo;
            String s = String.valueOf(d /= mult);
            int idx = s.indexOf(".");
            if (idx < 0) {
                if (num > 0) {
                    s = s + ".";
                    while (num > 0) {
                        s = s + "0";
                        --num;
                    }
                }
                return new JSString(s);
            }
            if (s.length() - idx <= num) {
                int toAdd = num + 1 - (s.length() - idx);
                for (int i = 0; i < toAdd; ++i) {
                    s = s + "0";
                }
                return new JSString(s);
            }
            if (num == 0) {
                return s.substring(0, idx);
            }
            return new JSString(s.substring(0, idx + 1 + num));
        }
    };
    public static String POSSIBLE_NUM;

    public JSNumber(int i) {
        this._val = i;
    }

    public JSNumber(double d) {
        this._val = d;
    }

    public JSNumber(Number val) {
        this._val = val;
    }

    public Number get() {
        return this._val;
    }

    @Override
    public byte byteValue() {
        return this._val.byteValue();
    }

    @Override
    public double doubleValue() {
        return this._val.doubleValue();
    }

    @Override
    public float floatValue() {
        return this._val.floatValue();
    }

    @Override
    public int intValue() {
        return this._val.intValue();
    }

    @Override
    public long longValue() {
        return this._val.longValue();
    }

    @Override
    public short shortValue() {
        return this._val.shortValue();
    }

    public String toString() {
        return this._val.toString();
    }

    @Override
    public Object set(Object n, Object v) {
        return v;
    }

    @Override
    public Object setInt(int n, Object v) {
        return v;
    }

    @Override
    public Object get(Object n) {
        return null;
    }

    @Override
    public Object getInt(int n) {
        return null;
    }

    @Override
    public JSFunction getFunction(String name) {
        return JSNumber.getFunctions().getFunction(name);
    }

    @Override
    public Object removeField(Object n) {
        return null;
    }

    @Override
    public boolean containsKey(String s) {
        return false;
    }

    @Override
    public boolean containsKey(String s, boolean includePrototype) {
        return false;
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> keySet(boolean includePrototype) {
        return new HashSet<String>();
    }

    @Override
    public JSFunction getConstructor() {
        return JSNumber.getCons();
    }

    @Override
    public JSObject getSuper() {
        return null;
    }

    public static final double self(double x) {
        return x;
    }

    public static final int self(int x) {
        return x;
    }

    public static Cons getCons() {
        return (Cons)Scope.getThreadLocalFunction("Number", new Cons());
    }

    public static JSObjectBase getFunctions() {
        return JSNumber.getCons()._prototype;
    }

    static Object _loop(Scope s, JSFunction f, int start, int end) {
        Object blah = s.getParent().getThis();
        s.setThis(blah);
        Boolean old = f.setUsePassedInScopeTL(true);
        for (int i = start; i < end; ++i) {
            f.call(s, i);
        }
        f.setUsePassedInScopeTL(old);
        s.clearThisNormal(null);
        return null;
    }

    public static double getDouble(Object a) {
        return JSNumber.getNumber(a).doubleValue();
    }

    public static Number getNumber(Object a) {
        if (a == null) {
            return 0;
        }
        if (a instanceof Number) {
            return (Number)a;
        }
        if (a instanceof Boolean || a instanceof JSBoolean) {
            return JSBoolean.booleanValue(a) ? 1 : 0;
        }
        if (a instanceof JSDate) {
            return ((JSDate)a).getTime();
        }
        if ((a instanceof String || a instanceof JSString) && a.toString().matches(POSSIBLE_NUM)) {
            return StringParseUtil.parseStrict((String)a.toString().trim());
        }
        return Double.NaN;
    }

    public static long toUintX(Object o, int size) {
        double d = JSNumber.getDouble(o);
        if (d == 0.0 || Double.isNaN(d) || Double.isInfinite(d)) {
            return 0L;
        }
        int sign = o.toString().startsWith("-") ? -1 : 1;
        return (long)sign * (long)Math.floor(Math.abs(d)) % (long)Math.pow(2.0, size);
    }

    public static int toInt32(Object o) {
        long preint = JSNumber.toUintX(o, 32);
        if (preint < (long)Math.pow(2.0, 31.0)) {
            return (int)preint;
        }
        return (int)(preint - (long)Math.pow(2.0, 32.0));
    }

    public static long toInt64(Object o) {
        long preint = JSNumber.toUintX(o, 64);
        if (preint < (long)Math.pow(2.0, 63.0)) {
            return preint;
        }
        return preint - (long)Math.pow(2.0, 64.0);
    }

    public static int toUint16(Object o) {
        return (int)JSNumber.toUintX(o, 16);
    }

    public static long toUint32(Object o) {
        return JSNumber.toUintX(o, 32);
    }

    public static long toUint64(Object o) {
        return JSNumber.toUintX(o, 64);
    }

    public static String formatNumber(Number o) {
        String s = o + "";
        if (s.toUpperCase().indexOf(69) > 0) {
            int exp = Integer.parseInt(s.substring(s.toUpperCase().indexOf(69) + 1));
            DecimalFormat df = new DecimalFormat("#0.#");
            df.setDecimalSeparatorAlwaysShown(false);
            df.setMaximumFractionDigits(20);
            df.setNegativePrefix("-");
            if (-7 < exp && exp < 21) {
                s = df.format(o);
            } else {
                df.applyPattern("0.#E0");
                df.setDecimalSeparatorAlwaysShown(false);
                df.setMaximumFractionDigits(20);
                df.setNegativePrefix("-");
                s = df.format(o);
                s = s.substring(0, s.indexOf("E")) + "e" + (exp > 0 ? "+" : "") + exp;
            }
        } else if (o.doubleValue() == 0.0 || s.endsWith(".0")) {
            return o.intValue() + "";
        }
        return s;
    }

    static {
        _functions.set("toFixed", toFixed);
        _functions.set("to_f", new JSFunctionCalls0(){

            public Object call(Scope s, Object[] foo) {
                return ((Number)s.getThis()).doubleValue();
            }
        });
        _functions.set("round", new JSFunctionCalls0(){

            public Object call(Scope s, Object[] foo) {
                return (int)(((Number)s.getThis()).doubleValue() + 0.5);
            }
        });
        _functions.set("times", new JSFunctionCalls1(){

            public Object call(Scope s, Object func, Object[] foo) {
                int t = ((Number)s.getThis()).intValue();
                JSFunction f = (JSFunction)func;
                return JSNumber._loop(s, f, 0, t);
            }
        });
        _functions.set("upto", new JSFunctionCalls2(){

            public Object call(Scope s, Object num, Object func, Object[] foo) {
                int start = ((Number)s.getThis()).intValue();
                int end = ((Number)num).intValue() + 1;
                JSFunction f = (JSFunction)func;
                return JSNumber._loop(s, f, start, end);
            }
        });
        _functions.set("chr", new JSFunctionCalls0(){

            public Object call(Scope s, Object[] foo) {
                return Character.valueOf((char)((Number)s.getThis()).intValue());
            }
        });
        _functions.set("zero_q_", new JSFunctionCalls0(){

            public Object call(Scope s, Object[] foo) {
                return ((Number)s.getThis()).doubleValue() == 0.0;
            }
        });
        _functions.set("valueOf", new JSFunctionCalls0(){

            public Object call(Scope s, Object[] foo) {
                Object o = s.getThis();
                if (o instanceof JSObjectBase && ((JSObjectBase)o).getConstructor() instanceof Cons) {
                    return ((Cons)((JSObjectBase)o).getConstructor())._parse(null, null);
                }
                if (o instanceof Number) {
                    return o;
                }
                if (!(o instanceof JSNumber)) {
                    throw new JSException((Object)"TypeError: valueOf must be called on a Number");
                }
                return ((JSNumber)o)._val;
            }
        });
        _functions.set("toString", new JSFunctionCalls0(){

            public Object call(Scope s, Object[] foo) {
                return new JSString(s.getThis().toString());
            }
        });
        _functions.set("kilobytes", new Conversion(1024.0));
        _functions.set("megabytes", new Conversion(1048576.0));
        _functions.set("seconds", new Conversion(1000.0));
        _functions.set("minutes", new Conversion(60000.0));
        _functions.set("hours", new Conversion(3600000.0));
        _functions.set("days", new Conversion(8.64E7));
        _functions.set("weeks", new Conversion(6.048E8));
        _functions.set("years", new Conversion(3.15576E10));
        POSSIBLE_NUM = "\\s*((\\+|-)?((Infinity)|(\\d*(\\.\\d+)?([eE]-?\\d+)?)|(0[xX][\\da-fA-F]+)))?\\s*";
    }

    public static class Conversion
    extends JSFunctionCalls0 {
        final double _conversion;

        Conversion(double conversion) {
            this._conversion = conversion;
        }

        public Object call(Scope s, Object[] foo) {
            Number n = (Number)s.getThis();
            return n.doubleValue() * this._conversion;
        }
    }

    public static class Cons
    extends JSFunctionCalls1 {
        public JSObject newOne() {
            return new JSNumber(0);
        }

        public Object call(Scope scope, Object a, Object[] extra) {
            Object def = 0;
            if (extra != null && extra.length > 0) {
                def = extra[0];
            }
            if (scope.getThis() instanceof JSNumber) {
                JSNumber n = (JSNumber)scope.getThis();
                n._val = this._parse(a, def);
                return n._val;
            }
            return this._parse(a, def);
        }

        Number _parse(Object a, Object b) {
            return JSNumber.getNumber(a == null ? b : a);
        }

        protected void init() {
            this._prototype.addAll(_functions);
            this.set("NaN", Double.NaN);
            this.set("POSITIVE_INFINITY", Double.POSITIVE_INFINITY);
            this.set("NEGATIVE_INFINITY", Double.NEGATIVE_INFINITY);
            this.set("MAX_VALUE", Double.MAX_VALUE);
            this.set("MIN_VALUE", Double.MIN_VALUE);
            this.setProperties("NaN", JSObjectBase.LOCK);
            this.setProperties("POSITIVE_INFINITY", JSObjectBase.LOCK);
            this.setProperties("NEGATIVE_INFINITY", JSObjectBase.LOCK);
            this.setProperties("MAX_VALUE", JSObjectBase.LOCK);
            this.setProperties("MIN_VALUE", JSObjectBase.LOCK);
            this.dontEnumExisting();
        }
    }
}

