/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JSNumber;
import ed.js.JSObjectBase;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls2;
import ed.util.StringParseUtil;

public class JSMath
extends JSObjectBase {
    public static final double LN10 = Math.log(10.0);
    public static final double LN2 = Math.log(2.0);
    public static final double LOG10E = Math.log10(Math.E);
    public static final double LOG2E = 1.4426950408889634;
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    public static final double SQRT1_2 = Math.sqrt(0.5);
    public static final double SQRT2 = Math.sqrt(2.0);

    public JSMath() {
        this.set("max", new JSFunctionCalls2(){

            public Object call(Scope s, Object[] foo) {
                return Double.NEGATIVE_INFINITY;
            }

            public Object call(Scope s, Object a, Object b, Object[] foo) {
                double d1 = JSNumber.getDouble(a);
                double d2 = JSNumber.getDouble(b);
                if (Double.isNaN(d1) || Double.isNaN(d2)) {
                    return Double.NaN;
                }
                return d1 > d2 ? d1 : d2;
            }
        });
        this.set("min", new JSFunctionCalls2(){

            public Object call(Scope s, Object[] foo) {
                return Double.POSITIVE_INFINITY;
            }

            public Object call(Scope s, Object a, Object b, Object[] foo) {
                double d1 = JSNumber.getDouble(a);
                double d2 = JSNumber.getDouble(b);
                if (Double.isNaN(d1) || Double.isNaN(d2)) {
                    return Double.NaN;
                }
                return d1 < d2 ? d1 : d2;
            }
        });
        this.set("random", new JSFunctionCalls0(){

            public Object call(Scope s, Object[] foo) {
                return Math.random();
            }
        });
        this.set("floor", new JSFunctionCalls1(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object a, Object[] foo) {
                double d = JSNumber.getDouble(a);
                if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
                    return d;
                }
                return (long)Math.floor(d);
            }
        });
        this.set("ceil", new JSFunctionCalls1(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object a, Object[] foo) {
                double d = JSNumber.getDouble(a);
                if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
                    return d;
                }
                return Math.ceil(d);
            }
        });
        this.set("round", new JSFunctionCalls1(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object a, Object[] foo) {
                if (a == null) {
                    return 0;
                }
                if (!(a instanceof Number)) {
                    if (a instanceof Boolean) {
                        boolean b = (Boolean)a;
                        return b ? 1 : 0;
                    }
                    try {
                        a = StringParseUtil.parseStrict((String)a.toString());
                    }
                    catch (Exception e) {
                        return Double.NaN;
                    }
                }
                if (a.equals(Double.NaN)) {
                    return Double.NaN;
                }
                if (a.equals(Double.POSITIVE_INFINITY)) {
                    return Double.POSITIVE_INFINITY;
                }
                if (a.equals(Double.NEGATIVE_INFINITY)) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (a.toString().equals("-0") || a.toString().equals("-0.0") || ((Number)a).doubleValue() >= -0.5 && ((Number)a).doubleValue() < 0.0) {
                    return -0.0;
                }
                return Math.round(((Number)a).doubleValue());
            }
        });
        this.set("abs", new JSFunctionCalls1(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object a, Object[] foo) {
                return Math.abs(JSNumber.getDouble(a));
            }
        });
        this.set("sqrt", new JSFunctionCalls1(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object a, Object[] foo) {
                return Math.sqrt(JSNumber.getDouble(a));
            }
        });
        this.set("posOrNeg", new JSFunctionCalls1(){

            public Object call(Scope s, Object a, Object[] foo) {
                if (!(a instanceof Number)) {
                    return 0;
                }
                Number n = (Number)a;
                double d = n.doubleValue();
                if (d > 0.0) {
                    return 1;
                }
                if (d < 0.0) {
                    return -1;
                }
                return 0;
            }
        });
        this.set("sigFig", new JSFunctionCalls2(){

            public Object call(Scope s, Object xObject, Object nObject, Object[] foo) {
                double X = ((Number)xObject).doubleValue();
                double N = nObject == null ? 3.0 : ((Number)nObject).doubleValue();
                return JSMath.sigFig(X, N);
            }
        });
        this.set("asin", new TrigFunc("asin"));
        this.set("acos", new TrigFunc("acos"));
        this.set("atan", new TrigFunc("atan"));
        this.set("sin", new TrigFunc("sin"));
        this.set("cos", new TrigFunc("cos"));
        this.set("tan", new TrigFunc("tan"));
        this.set("atan2", new JSFunctionCalls2(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object a, Object b, Object[] foo) {
                double d1 = JSNumber.getDouble(a);
                double d2 = JSNumber.getDouble(b);
                return Math.atan2(d1, d2);
            }
        });
        this.set("pow", new JSFunctionCalls2(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object baseArg, Object expArg, Object[] foo) {
                double exp;
                double base = JSNumber.getDouble(baseArg);
                double r = Math.pow(base, exp = JSNumber.getDouble(expArg));
                if (r != 0.0 && !Double.isInfinite(r) && Math.floor(r) == r) {
                    return (long)r;
                }
                return r;
            }
        });
        this.set("exp", new JSFunctionCalls1(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object expArg, Object[] foo) {
                double exp = JSNumber.getDouble(expArg);
                return Math.exp(exp);
            }
        });
        this.set("log", new JSFunctionCalls1(){

            public Object call(Scope s, Object[] foo) {
                return Double.NaN;
            }

            public Object call(Scope s, Object expArg, Object[] foo) {
                double exp = JSNumber.getDouble(expArg);
                return Math.log(exp);
            }
        });
        this.set("E", Math.E);
        this.set("PI", Math.PI);
        this.set("SQRT1_2", SQRT1_2);
        this.set("SQRT2", SQRT2);
        this.set("LN10", LN10);
        this.set("LN2", LN2);
        this.set("LOG10E", LOG10E);
        this.set("LOG2E", 1.4426950408889634);
        this.setProperties("E", JSObjectBase.LOCK);
        this.setProperties("PI", JSObjectBase.LOCK);
        this.setProperties("SQRT1_2", JSObjectBase.LOCK);
        this.setProperties("SQRT2", JSObjectBase.LOCK);
        this.setProperties("LN10", JSObjectBase.LOCK);
        this.setProperties("LN2", JSObjectBase.LOCK);
        this.setProperties("LOG10E", JSObjectBase.LOCK);
        this.setProperties("LOG2E", JSObjectBase.LOCK);
        this.dontEnumExisting();
    }

    public static double sigFig(double X) {
        return JSMath.sigFig(X, 3.0);
    }

    public static double sigFig(double X, double N) {
        double p = Math.pow(10.0, N - Math.ceil(Math.log(Math.abs(X)) / LN10));
        return (double)Math.round(X * p) / p;
    }

    static class TrigFunc
    extends JSFunctionCalls1 {
        private final types type;

        public TrigFunc(String s) {
            this.type = types.valueOf(s);
        }

        public Object call(Scope s, Object[] foo) {
            return Double.NaN;
        }

        public Object call(Scope s, Object xObject, Object[] foo) {
            double X = JSNumber.getDouble(xObject);
            return this.type.go(X);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum types {
            asin{

                public double go(double d) {
                    return Math.asin(d);
                }
            }
            ,
            acos{

                public double go(double d) {
                    return Math.acos(d);
                }
            }
            ,
            atan{

                public double go(double d) {
                    if (Double.isInfinite(d)) {
                        int sign = d > 0.0 ? 1 : -1;
                        return (double)sign * Math.PI / 2.0;
                    }
                    return Math.atan(d);
                }
            }
            ,
            sin{

                public double go(double d) {
                    return Math.sin(d);
                }
            }
            ,
            cos{

                public double go(double d) {
                    return Math.cos(d);
                }
            }
            ,
            tan{

                public double go(double d) {
                    return Math.tan(d);
                }
            };


            public abstract double go(double var1);
        }
    }
}

