/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.db.ObjectId;
import ed.js.JS;
import ed.js.JSArray;
import ed.js.JSBoolean;
import ed.js.JSDict;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSNumber;
import ed.js.JSNumericFunctions;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSRef;
import ed.js.JSString;
import ed.js.e4x.ENode;
import ed.js.e4x.Namespace;
import ed.js.e4x.QName;
import ed.js.engine.CompileOptions;
import ed.js.engine.Convert;
import ed.js.engine.JSBuiltInFunctions;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.util.StringParseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSInternalFunctions
extends JSNumericFunctions {
    public static final JSString TYPE_STRING;
    public static final JSString TYPE_NATIVE_STRING;
    public static final JSString TYPE_NUMBER;
    public static final JSString TYPE_BOOLEAN;
    public static final JSString TYPE_UNDEFINED;
    public static final JSString TYPE_OBJECT;
    public static final JSString TYPE_NATIVE;
    public static final JSString TYPE_FUNCTION;
    public static final JSString TYPE_OBJECTID;
    public static final JSString TYPE_XML;
    private static FunctionCons _defaultFunctionCons;
    static final List<String> EMPTY_STRING_LIST;
    public static final Void VOID;

    static JSFunction getFunctionCons() {
        return Scope.getThreadLocalFunction("Function", _defaultFunctionCons);
    }

    public JSInternalFunctions() {
        super(JSInternalFunctions.getFunctionCons());
    }

    public static final Object self(Object o) {
        return o;
    }

    public static boolean JS_instanceof(Object thing, Object type) {
        if (thing == null) {
            return false;
        }
        if (type == null) {
            throw new NullPointerException("type can't be null");
        }
        if (thing instanceof Number) {
            return false;
        }
        if (type instanceof String || type instanceof JSString) {
            try {
                Class clazz = JSBuiltInFunctions._getClass(type.toString());
                return clazz.isAssignableFrom(thing.getClass());
            }
            catch (Exception e) {
                throw new JSException((Object)("can't find : " + type), (Throwable)e);
            }
        }
        if (!(thing instanceof JSObject)) {
            return false;
        }
        if (type instanceof JSBuiltInFunctions.NewObject) {
            return true;
        }
        JSObject o = (JSObject)thing;
        if (o.getConstructor() == null) {
            return false;
        }
        return o.getConstructor() == type;
    }

    public JSString JS_typeof(Object obj) {
        if (obj == null || obj instanceof Void) {
            return TYPE_UNDEFINED;
        }
        if (obj instanceof JSString) {
            if (((JSString)obj).isObj()) {
                return TYPE_OBJECT;
            }
            return TYPE_STRING;
        }
        if (obj instanceof String) {
            return TYPE_NATIVE_STRING;
        }
        if (obj instanceof Number) {
            return TYPE_NUMBER;
        }
        if (obj instanceof Boolean) {
            return TYPE_BOOLEAN;
        }
        if (obj instanceof JSFunction) {
            return TYPE_FUNCTION;
        }
        if (obj instanceof ObjectId) {
            return TYPE_OBJECTID;
        }
        if (obj instanceof ENode) {
            return TYPE_XML;
        }
        if (obj instanceof JSObject) {
            return TYPE_OBJECT;
        }
        return TYPE_NATIVE;
    }

    public static JSObject JS_buildLiteralObject(String[] names, Object ... fields) {
        JSDict o = new JSDict();
        int max = names.length;
        if (fields != null) {
            max = Math.min(fields.length, max);
        }
        for (int i = 0; i < max; ++i) {
            o.set(names[i], fields == null ? null : fields[i]);
        }
        return o;
    }

    public Object JS_setDefferedOp(JSObject obj, Object place, Object other, int type) {
        Object nv = null;
        switch (type) {
            case 21: {
                nv = this.JS_add(obj.get(place), other);
                break;
            }
            case 22: {
                nv = this.JS_sub(obj.get(place), other);
                break;
            }
            case 23: {
                nv = this.JS_mul(obj.get(place), other);
                break;
            }
            case 24: {
                nv = this.JS_div(obj.get(place), other);
                break;
            }
            default: {
                throw new JSException((Object)"unknown op");
            }
        }
        return obj.set(place, nv);
    }

    public Object JS_inc(JSRef ref, boolean post, int num) {
        Object n;
        Object obj = ref.get();
        if (!(obj instanceof Number)) {
            obj = JSNumber.getDouble(obj);
            n = (Double)obj + (double)num;
            ref.set(n);
        } else {
            n = this.JS_add(num, obj);
            ref.set(n);
        }
        return post ? obj : n;
    }

    public static Object JS_or(Object a, Object b) {
        if (JSInternalFunctions.JS_evalToBool(a)) {
            return a;
        }
        return b;
    }

    public static Boolean JS_not(Object o) {
        return !JSBoolean.booleanValue(o);
    }

    public static boolean JS_evalToBool(Object foo) {
        if (foo == null || foo == VOID) {
            return false;
        }
        if (foo instanceof Boolean) {
            return (Boolean)foo;
        }
        if (foo instanceof Number) {
            Number n = (Number)foo;
            if (Double.isNaN(n.doubleValue())) {
                return false;
            }
            return n.doubleValue() != 0.0;
        }
        if (foo instanceof String || foo instanceof JSString) {
            return foo.toString().length() > 0;
        }
        return true;
    }

    public static Boolean JS_shne(Object a, Object b) {
        return JSInternalFunctions.JS_sheq(a, b) == false;
    }

    public static Boolean JS_ne(Object a, Object b) {
        return JSInternalFunctions.JS_eq(a, b) == false;
    }

    public static Boolean JS_sheq(Object a, Object b) {
        if (a == null && b == null || a instanceof Void && b instanceof Void) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Boolean && b instanceof Boolean) {
            return a.equals(b);
        }
        if (a instanceof Number && b instanceof Number) {
            a = JSInternalFunctions._parseNumber(a);
            b = JSInternalFunctions._parseNumber(b);
            if (Double.isNaN(((Number)a).doubleValue()) || Double.isNaN(((Number)b).doubleValue())) {
                return false;
            }
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        if (a instanceof JSString && b instanceof JSString) {
            return a.equals(b);
        }
        if (a instanceof String && b instanceof String) {
            return a.equals(b);
        }
        return a == b;
    }

    private static boolean _charEQ(Object a, Object b) {
        if (!(a instanceof String)) {
            return false;
        }
        if (!(b instanceof Character)) {
            return false;
        }
        String s = (String)a;
        Character c = (Character)b;
        if (s.length() != 1) {
            return false;
        }
        return s.charAt(0) == c.charValue();
    }

    public static Boolean JS_eq(Object a, Object b) {
        if (JSInternalFunctions.JS_sheq(a, b).booleanValue()) {
            return true;
        }
        if (a instanceof Void && b == null || b instanceof Void && a == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof ENode || a instanceof QName || a instanceof Namespace) {
            a = a.toString();
        }
        if (b instanceof ENode || b instanceof QName || b instanceof Namespace) {
            b = b.toString();
        }
        if (a instanceof JSObject && b instanceof JSObject) {
            return a.equals(b);
        }
        if (a instanceof JSString) {
            a = a.toString();
        }
        if (b instanceof JSString) {
            b = b.toString();
        }
        if (a instanceof JSBoolean || a instanceof Boolean) {
            a = JSBoolean.booleanValue(a) ? 1 : 0;
        }
        if (b instanceof JSBoolean || b instanceof Boolean) {
            b = JSBoolean.booleanValue(b) ? 1 : 0;
        }
        if (a instanceof Number && b instanceof String && b.toString().matches(JSNumber.POSSIBLE_NUM)) {
            a = ((Number)a).doubleValue();
            b = StringParseUtil.parseStrict((String)b.toString()).doubleValue();
        }
        if (b instanceof Number && a instanceof String && a.toString().matches(JSNumber.POSSIBLE_NUM)) {
            a = StringParseUtil.parseStrict((String)a.toString()).doubleValue();
            b = ((Number)b).doubleValue();
        }
        if (a instanceof Number && Double.isNaN(((Number)a).doubleValue()) || b instanceof Number && Double.isNaN(((Number)b).doubleValue())) {
            return false;
        }
        if (a instanceof String) {
            return a.equals(b.toString());
        }
        return a.equals(b);
    }

    public static Boolean JS_ge(Object a, Object b) {
        return JSInternalFunctions._compare(a, b) >= 0.0;
    }

    public static Boolean JS_le(Object a, Object b) {
        return JSInternalFunctions._compare(a, b) <= 0.0;
    }

    public static Boolean JS_lt(Object a, Object b) {
        return JSInternalFunctions._compare(a, b) < 0.0;
    }

    public static Boolean JS_gt(Object a, Object b) {
        return JSInternalFunctions._compare(a, b) > 0.0;
    }

    static final double _compare(Object a, Object b) {
        if (a == null) {
            if (b == null) {
                return 0.0;
            }
            if (b instanceof Number) {
                return JSInternalFunctions._compare(0, (Number)b);
            }
            return 1.0;
        }
        if (b == null) {
            if (a == null) {
                return 0.0;
            }
            if (a instanceof Number) {
                return JSInternalFunctions._compare((Number)a, 0);
            }
            return -1.0;
        }
        if (a instanceof Number ? (b = JSInternalFunctions._parseNumber(b)) instanceof Number : b instanceof Number && (a = JSInternalFunctions._parseNumber(a)) instanceof Number) {
            return JSInternalFunctions._compare((Number)a, (Number)b);
        }
        if (a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        if (a.equals(b)) {
            return 0.0;
        }
        return a.toString().compareTo(b.toString());
    }

    static final double _compare(Number a, Number b) {
        if (Double.isNaN(a.doubleValue()) || Double.isNaN(b.doubleValue())) {
            return Double.NaN;
        }
        double diff = a.doubleValue() - b.doubleValue();
        if (diff == 0.0) {
            return 0.0;
        }
        if (diff < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static final Object parseNumber(Object o, Object def) {
        Number r = JSInternalFunctions._parseNumber(o);
        if (r instanceof Number) {
            return r;
        }
        return JSInternalFunctions._parseNumber(def);
    }

    public static final Collection<String> JS_collForFor(Object o) {
        if (o == null) {
            return new LinkedList<String>();
        }
        if (o instanceof JSObject) {
            return ((JSObject)o).keySet();
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        if (o instanceof Number) {
            return EMPTY_STRING_LIST;
        }
        throw new RuntimeException("can't for with a : " + o.getClass());
    }

    public static final Iterable JS_collForForEach(Object o) {
        if (o == null) {
            return new LinkedList();
        }
        if (o instanceof ENode) {
            return ((ENode)o).valueSet();
        }
        if (o instanceof Iterable) {
            return (Iterable)o;
        }
        if (o instanceof JSObject) {
            JSObject j = (JSObject)o;
            Set<String> keys = j.keySet();
            ArrayList<Object> values = new ArrayList<Object>(keys.size());
            for (String k : keys) {
                values.add(j.get(k));
            }
            return values;
        }
        throw new RuntimeException("can't for each with a : " + o.getClass());
    }

    public static final Object JS_comma(Object ... o) {
        if (o == null || o.length == 0) {
            return null;
        }
        return o[o.length - 1];
    }

    public static long hash(Object o) {
        long hash = 0L;
        if (o == null) {
            return hash;
        }
        if (o instanceof Collection) {
            for (Object foo : (Collection)o) {
                if (o == foo) continue;
                hash += JSInternalFunctions.hash(foo);
            }
        } else if (o.getClass().isArray()) {
            Object[] a = (Object[])o;
            for (int i = 0; i < a.length; ++i) {
                hash += JSInternalFunctions.hash(a[i]);
            }
        } else {
            hash += (long)o.hashCode();
        }
        return hash;
    }

    public static final JSObject JS_toJSObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSObject) {
            return (JSObject)o;
        }
        if (o instanceof Number) {
            return new JSNumber((Number)o);
        }
        if (o instanceof Boolean) {
            return new JSBoolean(o);
        }
        if (o instanceof String) {
            return new JSString(o.toString());
        }
        throw new RuntimeException("can't convert [" + o.getClass() + "] to a JSObject");
    }

    static String _debug(Object o) {
        if (o == null) {
            return "null";
        }
        return "[" + o + "](" + o.getClass() + ")";
    }

    static {
        JS._debugSIStart("JSInternalFunctions");
        JS._debugSI("JSInternalFunctions", "0");
        TYPE_STRING = new JSString("string");
        JS._debugSI("JSInternalFunctions", "0.1");
        TYPE_NATIVE_STRING = new JSString("native_string");
        TYPE_NUMBER = new JSString("number");
        TYPE_BOOLEAN = new JSString("boolean");
        TYPE_UNDEFINED = new JSString("undefined");
        TYPE_OBJECT = new JSString("object");
        TYPE_NATIVE = new JSString("native");
        TYPE_FUNCTION = new JSString("function");
        TYPE_OBJECTID = new JSString("objectid");
        TYPE_XML = new JSString("xml");
        JS._debugSI("JSInternalFunctions", "1");
        _defaultFunctionCons = new FunctionCons();
        JS._debugSI("JSInternalFunctions", "2");
        JS._debugSIDone("JSInternalFunctions");
        EMPTY_STRING_LIST = Collections.synchronizedList(new LinkedList());
        VOID = Void.getInstance();
    }

    public static class Void {
        private static Void instance = null;

        private Void() {
        }

        public static Void getInstance() {
            if (instance == null) {
                instance = new Void();
            }
            return instance;
        }

        public String toString() {
            return "null";
        }
    }

    public static class FunctionCons
    extends JSFunctionCalls1 {
        public JSObject newOne() {
            return new JSFunctionCalls0(){

                public Object call(Scope s, Object[] extra) {
                    return null;
                }
            };
        }

        public Object call(Scope s, Object foo, Object[] extra) {
            Object o;
            String[] argList;
            String precode;
            if (foo == null && extra == null) {
                return this.newOne();
            }
            String string = precode = foo == null ? "return null" : foo.toString();
            if (extra.length > 0) {
                precode = extra[extra.length - 1].toString();
            }
            final String code = precode;
            if (extra.length > 0) {
                String argsStr = foo.toString();
                for (int i = 0; i < extra.length - 1; ++i) {
                    argsStr = argsStr + "," + extra[i];
                }
                argList = argsStr.split(",");
            } else {
                argList = new String[]{};
            }
            final Object innerThis = s.getParent().getThis();
            JSFunctionCalls0 func = new JSFunctionCalls0(){

                public Object call(Scope s2, Object[] extra2) {
                    Scope local = s2.child();
                    local.setThis(innerThis);
                    if (this._arguments != null) {
                        int namedArgs = Math.min(this._arguments.size(), extra2.length);
                        for (int i = 0; i < namedArgs; ++i) {
                            local.set(this._arguments.get(i).toString(), extra2[i]);
                        }
                    }
                    try {
                        String randomFile = "anon" + Math.random();
                        Convert c = new Convert(randomFile, code, CompileOptions.forEval());
                        return c.get().call(local, extra2);
                    }
                    catch (IOException e) {
                        System.out.println("couldn't convert " + code + ":");
                        e.printStackTrace();
                        return null;
                    }
                }
            };
            if (extra.length > 0) {
                ArrayList<String> list = new ArrayList<String>();
                for (String arg : argList) {
                    if (list.contains(arg)) {
                        int index = list.indexOf(arg);
                        list.remove(index);
                        list.add(index, arg + Math.floor(Math.random() * 100000.0));
                    }
                    list.add(arg);
                }
                func._arguments = new JSArray((Collection)list);
            }
            if ((o = s.getThis()) instanceof JSFunction) {
                s.clearThisNormal(o);
                s.setThis(func);
            }
            return func;
        }

        protected void init() {
            JSFunction._init(this);
            this.setProperties("prototype", JSObjectBase.LOCK);
        }
    }
}

