/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JSArray;
import ed.js.JSFunction;
import ed.js.JSNumber;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls2;
import ed.util.IdentitySet;
import ed.util.Strftime;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class JSDate
extends JSObjectBase
implements Comparable {
    public static JSFunction _cons = new Cons();
    long _time;
    Calendar _c;
    public static final DateFormat _defaultFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z (z)");
    public static final DateFormat _simpleFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
    public static final DateFormat _webFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    public static final DateFormat _utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final DateFormat[] DATE_FORMATS;

    static long parse(Object o) {
        return JSDate.parse(o, System.currentTimeMillis());
    }

    static long parse(Object o, long def) {
        if (o == null) {
            return def;
        }
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        if (o instanceof String || o instanceof JSString) {
            return JSDate.parseDate(o.toString(), def);
        }
        if (Double.isNaN(((Number)(o = JSNumber.getNumber(o))).doubleValue())) {
            return def;
        }
        return ((Number)o).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseDate(String s, long def) {
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).length() == 0) {
            return def;
        }
        for (int i = 0; i < DATE_FORMATS.length; ++i) {
            try {
                DateFormat dateFormat = DATE_FORMATS[i];
                synchronized (dateFormat) {
                    return DATE_FORMATS[i].parse(s).getTime();
                }
            }
            catch (ParseException e) {
                continue;
            }
        }
        return def;
    }

    public JSDate() {
        this(System.currentTimeMillis());
    }

    public JSDate(long t) {
        super(Scope.getThreadLocalFunction("Date", _cons));
        this._time = t;
    }

    public JSDate(Calendar c) {
        this(c.getTimeInMillis());
    }

    public JSDate(Object foo) {
        this(JSDate.parse(foo));
    }

    public long getTime() {
        return this._time;
    }

    public int getYear() {
        this._cal();
        int y = this._c.get(1);
        if (y >= 0 && y < 200) {
            return 1900 + y;
        }
        return y;
    }

    public int getFullYear() {
        this._cal();
        return this._c.get(1);
    }

    public int getMonth() {
        this._cal();
        return this._c.get(2);
    }

    public int getDay() {
        this._cal();
        return this._c.get(7);
    }

    public int getHours() {
        this._cal();
        return this._c.get(11);
    }

    public int getMilliseconds() {
        this._cal();
        return this._c.get(14);
    }

    public int getSeconds() {
        this._cal();
        return this._c.get(13);
    }

    public int getDate() {
        this._cal();
        return this._c.get(5);
    }

    public int getHourOfDay() {
        this._cal();
        return this._c.get(11);
    }

    public int getTimezoneOffset() {
        this._cal();
        return this._c.get(15);
    }

    public int minutes() {
        return this.getMinute();
    }

    public int getMinutes() {
        return this.getMinute();
    }

    public int getMinute() {
        this._cal();
        return this._c.get(12);
    }

    public long setDate(int day) {
        this._cal();
        this._c.set(5, day);
        this._time = this._c.getTimeInMillis();
        return this._c.getTimeInMillis();
    }

    public long setFullYear(int year, int month, int day) {
        this.setMonth(month);
        this.setDate(day);
        return this.setFullYear(year);
    }

    public long setFullYear(int year, int month) {
        this.setMonth(month);
        return this.setFullYear(year);
    }

    public long setFullYear(int year) {
        this._cal();
        this._c.set(1, year);
        this._time = this._c.getTimeInMillis();
        return this._c.getTimeInMillis();
    }

    public long setHours(int hour, int min, int sec, int ms) {
        this.setMinutes(min);
        this.setSeconds(sec);
        this.setMilliseconds(ms);
        return this.setHours(hour);
    }

    public long setHours(int hour, int min, int sec) {
        this.setMinutes(min);
        this.setSeconds(sec);
        return this.setHours(hour);
    }

    public long setHours(int hour, int min) {
        this.setMinutes(min);
        return this.setHours(hour);
    }

    public long setHours(int hour) {
        this._cal();
        this._c.set(11, hour);
        this._time = this._c.getTimeInMillis();
        return this._c.getTimeInMillis();
    }

    public long setMilliseconds(int ms) {
        this._cal();
        this._c.set(14, ms);
        this._time = this._c.getTimeInMillis();
        return this._c.getTimeInMillis();
    }

    public long setMinutes(int min, int sec, int ms) {
        this.setSeconds(sec);
        this.setMilliseconds(ms);
        return this.setMinutes(min);
    }

    public long setMinutes(int min, int sec) {
        this.setSeconds(sec);
        return this.setMinutes(min);
    }

    public long setMinutes(int min) {
        this._cal();
        this._c.set(12, min);
        this._time = this._c.getTimeInMillis();
        return this._c.getTimeInMillis();
    }

    public long setMonth(int month, int day) {
        this.setDate(day);
        return this.setMonth(month);
    }

    public long setMonth(int month) {
        this._cal();
        this._c.set(2, month);
        this._time = this._c.getTimeInMillis();
        return this._c.getTimeInMillis();
    }

    public long setYear(int year) {
        this._cal();
        this._c.set(1, year);
        this._time = this._c.getTimeInMillis();
        return this._c.getTimeInMillis();
    }

    public long setSeconds(int sec, int ms) {
        this.setMilliseconds(ms);
        return this.setSeconds(sec);
    }

    public long setSeconds(int sec) {
        this._cal();
        this._c.set(13, sec);
        this._time = this._c.getTimeInMillis();
        return this._c.getTimeInMillis();
    }

    public long setTime(long ms) {
        this._cal();
        this._c.setTimeInMillis(ms);
        this._time = this._c.getTimeInMillis();
        return this._time;
    }

    public String toString() {
        return this.format(_defaultFormat);
    }

    public String strftime(String theFormat) {
        return this.format(Strftime.convertDateFormat((String)theFormat));
    }

    public String format(String theFormat) {
        return this.format(theFormat, JSDate.getTimeZone());
    }

    public String format(String theFormat, String tz) {
        return this.format(theFormat, TimeZone.getTimeZone(tz));
    }

    public String format(String theFormat, TimeZone tz) {
        SimpleDateFormat df = new SimpleDateFormat(theFormat);
        df.setTimeZone(tz);
        return df.format(new Date(this._time));
    }

    public String webFormat() {
        return this.format(_webFormat);
    }

    public String simpleFormat() {
        return this.format(_simpleFormat);
    }

    public String format(DateFormat df) {
        return this.format(df, JSDate.getTimeZone());
    }

    public String format(DateFormat df, String tz) {
        return this.format(df, TimeZone.getTimeZone(tz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(DateFormat df, TimeZone tz) {
        if (df == null) {
            df = _simpleFormat;
        }
        if (tz == null) {
            tz = JSDate.getTimeZone();
        }
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            df.setTimeZone(tz);
            return df.format(new Date(this._time));
        }
    }

    public JSDate roundMonth() {
        return new JSDate(this._roundMonth());
    }

    public JSDate roundWeek() {
        return new JSDate(this._roundWeek());
    }

    public JSDate roundDay() {
        return new JSDate(this._roundDay());
    }

    public JSDate roundHour() {
        return new JSDate(this._roundHour());
    }

    public Date toJavaDate() {
        return new Date(this._time);
    }

    public Calendar _roundMonth() {
        Calendar c = this._roundDay();
        c.set(5, 1);
        return c;
    }

    public Calendar _roundWeek() {
        Calendar c = this._roundDay();
        while (true) {
            if (c.get(7) == 2) break;
            c.setTimeInMillis(c.getTimeInMillis() - 86400000L);
        }
        return c;
    }

    public Calendar _roundDay() {
        Calendar c = this._roundHour();
        c.set(11, 0);
        return c;
    }

    public Calendar _roundHour() {
        Calendar c = JSDate.getCalendar();
        c.setTimeInMillis(this._time);
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        return c;
    }

    public JSDate roundMinutes(int min) {
        Calendar c = JSDate.getCalendar();
        c.setTimeInMillis(this._time);
        c.set(14, 0);
        c.set(13, 0);
        double m = c.get(12);
        c.set(12, min * (int)(m /= (double)min));
        return new JSDate(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toUTCString() {
        DateFormat dateFormat = _utcFormat;
        synchronized (dateFormat) {
            return _utcFormat.format(new Date(this._time));
        }
    }

    public JSDate utc() {
        return this;
    }

    private void _cal() {
        if (this._c != null) {
            return;
        }
        this._c = JSDate.getCalendar();
        this._c.setTimeInMillis(this._time);
        this._c.setTimeZone(JSDate.getTimeZone());
    }

    public int compareTo(Object o) {
        long t = -1L;
        if (o instanceof JSDate) {
            t = ((JSDate)o)._time;
        }
        if (t < 0L) {
            return 0;
        }
        long diff = this._time - t;
        if (diff == 0L) {
            return 0;
        }
        if (diff < 0L) {
            return -1;
        }
        return 1;
    }

    public int hashCode(IdentitySet seen) {
        return (int)this._time;
    }

    public boolean equals(Object o) {
        return o instanceof JSDate && this._time == ((JSDate)o)._time;
    }

    public static Calendar getCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(JSDate.getTimeZone());
        return c;
    }

    public static TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    static {
        _webFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        _utcFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_FORMATS = new DateFormat[]{_webFormat, _simpleFormat, new SimpleDateFormat("yyyy-dd-MM HH:mm:ss z"), new SimpleDateFormat("yyyy-dd-MM HH:mm: z"), new SimpleDateFormat("yyyy-dd-MM HH:mm:ss"), new SimpleDateFormat("yyyy-dd-MM HH:mm"), new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss")};
    }

    public static class Cons
    extends JSFunctionCalls1 {
        public JSObject newOne() {
            return new JSDate();
        }

        public Object call(Scope s, Object foo, Object[] args) {
            long l;
            Object o;
            if (args != null && args.length > 0) {
                int[] myargs = new int[8];
                for (int i = 0; i < args.length + 1 && i < myargs.length; ++i) {
                    Object o2 = i == 0 ? foo : args[i - 1];
                    myargs[i] = JSNumber.getNumber(o2).intValue();
                }
                Calendar c = JSDate.getCalendar();
                c.set(myargs[0], myargs[1], myargs[2], myargs[3], myargs[4], myargs[5]);
                c.set(14, myargs[6]);
                foo = new Long(c.getTimeInMillis());
            }
            if ((o = s.getThis()) == null || !(o instanceof JSDate)) {
                return new JSString(new JSDate(foo).toString());
            }
            JSDate d = (JSDate)o;
            d._time = l = JSDate.parse(foo, d._time);
            return d;
        }

        protected void init() {
            this._prototype.set("getTime", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return ((JSDate)s.getThis())._time;
                }
            });
            this._prototype.set("getTimezoneOffset", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return ((JSDate)s.getThis()).getTimezoneOffset();
                }
            });
            this._prototype.set("utc", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return ((JSDate)s.getThis()).utc();
                }
            });
            this._prototype.set("utc_to_local", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return s.getThis();
                }
            });
            this._prototype.set("next_month", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSDate d = (JSDate)s.getThis();
                    JSDate n = new JSDate(d._time);
                    n.setMonth(n.getMonth() + 1);
                    return n;
                }
            });
            this._prototype.set("last_month", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSDate d = (JSDate)s.getThis();
                    JSDate n = new JSDate(d._time);
                    n.setMonth(n.getMonth() - 1);
                    return n;
                }
            });
            this._prototype.set("strftime", new JSFunctionCalls1(){

                public Object call(Scope s, Object f, Object[] foo) {
                    return ((JSDate)s.getThis()).strftime(f.toString());
                }
            });
            this._prototype.set("valueOf", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    return ((JSDate)s.getThis())._time;
                }
            });
            this._prototype.set("toString", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    return new JSString(((JSDate)s.getThis()).toString());
                }
            });
            this.set("now", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return new JSDate();
                }
            });
            this.set("parse", new JSFunctionCalls1(){

                public Object call(Scope s, Object when, Object[] foo) {
                    long t = JSDate.parse(when, -1L);
                    if (t < 0L) {
                        return null;
                    }
                    return new JSDate(t);
                }
            });
            this.set("DAYNAMES", new JSArray(new JSString("Sunday"), new JSString("Monday"), new JSString("Tuesday"), new JSString("Wednesday"), new JSString("Thursday"), new JSString("Friday"), new JSString("Saturday")));
            this.set("civil", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return s.getThis();
                }
            });
            this.set("timeFunc", new JSFunctionCalls2(){

                public Object call(Scope s, Object func, Object numTimes, Object[] extra) {
                    if (!(func instanceof JSFunction)) {
                        throw new RuntimeException("Date.timeFunc needs a function not : " + func);
                    }
                    if (!(numTimes instanceof Number)) {
                        numTimes = 1;
                    }
                    JSFunction f = (JSFunction)func;
                    int times = ((Number)numTimes).intValue();
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < times; ++i) {
                        f.call(s, extra);
                    }
                    return System.currentTimeMillis() - start;
                }
            });
            this._prototype.dontEnumExisting();
        }
    }
}

