/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSNumber;
import ed.js.JSNumericFunctions;
import ed.js.JSON;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSObjectSize;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls2;
import ed.util.CollectionEnumeration;
import ed.util.IdentitySet;
import ed.util.OrderedSet;
import ed.util.SeenPath;
import ed.util.StringParseUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSArray
extends JSObjectBase
implements Iterable,
List {
    private static final JSFunction _cons = new JSArrayCons();
    private boolean _new = false;
    final ArrayList<Object> _array;
    static final MyComparator _normalComparator = new MyComparator(null, null);

    private static JSFunction _getCons() {
        return Scope.getThreadLocalFunction("Array", _cons);
    }

    public static JSArray create(Object ... obj) {
        return new JSArray(obj);
    }

    public JSArray() {
        this(0);
    }

    public JSArray(int init) {
        super(JSArray._getCons());
        this._array = new ArrayList(Math.max(16, init));
        this._initSizeSet(init);
    }

    private void _initSizeSet(int init) {
        this._array.ensureCapacity(init);
        for (int i = 0; i < init; ++i) {
            this._array.add(null);
        }
    }

    public JSArray(Object ... obj) {
        super(JSArray._getCons());
        if (obj == null) {
            this._array = new ArrayList();
        } else {
            this._array = new ArrayList(obj.length);
            for (Object o : obj) {
                this._array.add(o);
            }
        }
    }

    public JSArray(JSArray a) {
        super(JSArray._getCons());
        this._array = a == null ? new ArrayList() : new ArrayList<Object>(a._array);
    }

    public JSArray(Collection coll) {
        super(JSArray._getCons());
        this._array = coll == null ? new ArrayList() : new ArrayList(coll);
    }

    private JSArray(ArrayList lst) {
        super(JSArray._getCons());
        if (lst == null) {
            throw new NullPointerException("can't pass a null lst to this special constructor");
        }
        this._array = lst;
    }

    public static JSArray wrap(ArrayList lst) {
        return new JSArray(lst);
    }

    @Override
    public Object setInt(int pos, Object v) {
        this._readOnlyCheck();
        while (this._array.size() <= pos) {
            this._array.add(null);
        }
        this._array.set(pos, v);
        return v;
    }

    @Override
    public Object getInt(int pos) {
        if (pos >= this._array.size()) {
            return null;
        }
        return this._array.get(pos);
    }

    @Override
    public int size() {
        return this._array.size();
    }

    @Override
    public Object get(Object n) {
        if (n != null && (n instanceof JSString || n instanceof String) && n.toString().equals("length")) {
            return this._array.size();
        }
        int idx = this._getInt(n);
        if (idx >= 0) {
            return this.getInt(idx);
        }
        return super.get(n);
    }

    @Override
    public Object set(Object n, Object v) {
        int idx = this._parseSimpleString(n);
        if (idx >= 0) {
            return this.setInt(idx, v);
        }
        if (n.toString().matches(JSNumber.POSSIBLE_NUM)) {
            idx = JSNumber.toInt32(n);
            return this.setInt(idx, v);
        }
        if (n.toString().equals("")) {
            this._array.add(v);
            return v;
        }
        if (n.toString().equals("length")) {
            double newLen = JSNumber.getDouble(v);
            if (newLen < 0.0 || Double.isInfinite(newLen) || Double.isNaN(newLen)) {
                throw new RuntimeException("length must be a positive number.");
            }
            int startLen = this._array.size();
            int i = startLen - 1;
            while ((double)i >= newLen) {
                this._array.remove(i);
                --i;
            }
            int addLen = (int)newLen - startLen;
            if (addLen > 0) {
                Object[] o = new Object[addLen];
                for (int i2 = 0; i2 < o.length; ++i2) {
                    o[i2] = null;
                }
                Collections.addAll(this._array, o);
            }
            this.getConstructor()._prototype.set("length", this._array.size());
            return v;
        }
        return super.set(n, v);
    }

    private int _parseSimpleString(Object n) {
        if (n instanceof Integer || n instanceof Long) {
            return ((Number)n).intValue();
        }
        if (n instanceof Number && JSNumericFunctions.couldBeInt(((Number)n).doubleValue())) {
            return ((Number)n).intValue();
        }
        if (!(n instanceof String) && !(n instanceof JSString)) {
            return -1;
        }
        String s = n.toString();
        if (s.length() > 7) {
            return -1;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return -1;
        }
        return Integer.parseInt(s);
    }

    @Override
    public Object removeField(Object n) {
        int idx = this._getInt(n);
        if (idx < 0) {
            return super.removeField(n);
        }
        if (idx >= this._array.size()) {
            return null;
        }
        return this._array.set(idx, null);
    }

    @Override
    public Set<String> keySet(boolean includePrototype) {
        Set<String> p = super.keySet(includePrototype);
        OrderedSet keys = new OrderedSet();
        for (int i = 0; i < this._array.size(); ++i) {
            keys.add(String.valueOf(i));
        }
        keys.addAll(p);
        keys.remove("_dbCons");
        return keys;
    }

    @Override
    public boolean containsKey(String s) {
        if ("length".equals(s)) {
            return true;
        }
        int idx = StringParseUtil.parseIfInt((String)s, (int)-1);
        if (idx >= 0) {
            return idx < this._array.size();
        }
        return super.containsKey(s);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this._array.size(); ++i) {
            Object val;
            if (i > 0) {
                buf.append(",");
            }
            buf.append((val = this._array.get(i)) == null || val == JSInternalFunctions.VOID ? "" : JSInternalFunctions.JS_toString(val));
        }
        return buf.toString();
    }

    @Override
    public boolean add(Object o) {
        this._readOnlyCheck();
        return this._array.add(o);
    }

    public void add(int index, Object o) {
        this._readOnlyCheck();
        this._array.add(index, o);
    }

    public Object set(int index, Object o) {
        return this.setInt(index, o);
    }

    public Object get(int i) {
        if (i >= this._array.size()) {
            return null;
        }
        return this._array.get(i);
    }

    @Override
    public boolean addAll(Collection c) {
        this._readOnlyCheck();
        return this._array.addAll(c);
    }

    public boolean addAll(int idx, Collection c) {
        this._readOnlyCheck();
        return this._array.addAll(idx, c);
    }

    public void addAll(Enumeration e) {
        this._readOnlyCheck();
        while (e.hasMoreElements()) {
            this.add(e.nextElement());
        }
    }

    public void addAll(Iterator i) {
        this._readOnlyCheck();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    @Override
    public boolean containsAll(Collection c) {
        return this._array.containsAll(c);
    }

    public List subList(int start, int end) {
        return this._array.subList(start, end);
    }

    public ListIterator listIterator() {
        return this._array.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this._array.listIterator(index);
    }

    public Enumeration getEnumeration() {
        return new CollectionEnumeration((Collection)this);
    }

    @Override
    public int lastIndexOf(Object foo) {
        return this._array.lastIndexOf(foo);
    }

    @Override
    public int indexOf(Object foo) {
        return this._array.indexOf(foo);
    }

    @Override
    public boolean contains(Object foo) {
        for (int i = 0; i < this._array.size(); ++i) {
            Object o = this._array.get(i);
            if (o == null || !o.equals(foo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this._array.isEmpty();
    }

    public Object remove(int i) {
        this._readOnlyCheck();
        return this._array.remove(i);
    }

    @Override
    public boolean remove(Object o) {
        this._readOnlyCheck();
        return this._array.remove(o);
    }

    @Override
    public Iterator iterator() {
        return this._array.iterator();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean removedAny = false;
        for (Object o : c) {
            removedAny = this.remove(o) || removedAny;
        }
        return removedAny;
    }

    @Override
    public Object[] toArray() {
        return this._array.toArray();
    }

    @Override
    public Object[] toArray(Object[] o) {
        return this._array.toArray(o);
    }

    public int _getInt(Object o) {
        if (o == null) {
            return -1;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof JSString) {
            o = o.toString();
        }
        if (!(o instanceof String)) {
            return -1;
        }
        String str = o.toString();
        if (str.length() == 0) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return -1;
        }
        return Integer.parseInt(str);
    }

    public JSArray shuffle() {
        Collections.shuffle(this._array);
        return this;
    }

    @Override
    public void clear() {
        this._array.clear();
    }

    @Override
    JSFunction getGetter(String name) {
        return null;
    }

    @Override
    JSFunction getSetter(String name) {
        return null;
    }

    public static Object fixAndCall(Scope s, JSFunction f, Object o) {
        return f.call(s, o);
    }

    @Override
    protected int hashCode(IdentitySet seen) {
        int hash = super.hashCode(seen);
        if (this._array != null) {
            for (Object foo : this._array) {
                hash += 17 + this._hash(seen, foo);
            }
        }
        return hash;
    }

    @Override
    public long approxSize(SeenPath seen) {
        long sum = super.approxSize(seen);
        return sum += JSObjectSize.size(this._array, seen, this);
    }

    static class MyComparator
    implements Comparator {
        private final Scope _scope;
        private final JSFunction _func;

        MyComparator(Scope s, JSFunction func) {
            this._scope = s;
            this._func = func;
        }

        public int compare(Object l, Object r) {
            if (this._func == null) {
                if (l == null && r == null) {
                    return 0;
                }
                if (l == null) {
                    return 1;
                }
                if (r == null) {
                    return -1;
                }
                return l.toString().compareTo(r.toString());
            }
            return ((Number)this._func.call(this._scope, l, r, null)).intValue();
        }
    }

    public static class JSArrayCons
    extends JSFunctionCalls1 {
        public JSObject newOne() {
            JSArray a = new JSArray();
            a._new = true;
            return a;
        }

        public Object call(Scope scope, Object a, Object[] extra) {
            int len = 0;
            if (extra == null || extra.length == 0) {
                if (a instanceof Number) {
                    len = ((Number)a).intValue();
                }
            } else {
                len = 1 + extra.length;
            }
            JSArray arr = null;
            Object t = scope.getThis();
            if (t != null && t instanceof JSArray && ((JSArray)t)._new) {
                arr = (JSArray)t;
                if (len > 0) {
                    arr._initSizeSet(len);
                }
                arr._new = false;
            } else {
                arr = new JSArray(len);
            }
            if (a != null && !(a instanceof Number) || extra != null && extra.length > 0) {
                arr.setInt(0, a);
                if (extra != null) {
                    for (int i = 0; i < extra.length; ++i) {
                        arr.setInt(1 + i, extra[i]);
                    }
                }
            }
            this._prototype.set("length", arr._array.size());
            this._prototype.setProperties("length", JSObjectBase.DONT_ENUM | JSObjectBase.DONT_DELETE);
            return arr;
        }

        protected void init() {
            final JSObjectBase p = this._prototype;
            this._prototype.set("toString", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    Object o = s.getThis();
                    if (o == p) {
                        return new JSString("");
                    }
                    return new JSString(s.getThis().toString());
                }
            });
            this._prototype.set("toSource", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return new JSString(JSON.serialize(s.getThis()));
                }
            });
            this._prototype.set("valueOf", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return s.getThis();
                }
            });
            this._prototype.set("reverse", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    Collections.reverse(a._array);
                    return a;
                }
            });
            this._prototype.set("pop", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    return a._array.remove(a._array.size() - 1);
                }
            });
            this._prototype.set("shift", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    if (a.size() == 0) {
                        return VOID;
                    }
                    return a._array.remove(0);
                }
            });
            this._prototype.set("join", new JSFunctionCalls1(){

                public Object call(Scope s, Object strJS, Object[] foo) {
                    StringBuilder buf = new StringBuilder();
                    String str = ",";
                    if (strJS != null && strJS != VOID) {
                        str = strJS.toString();
                    }
                    JSObjectBase b = (JSObjectBase)s.getThis();
                    int i = 0;
                    while (b.containsKey(i + "")) {
                        Object o;
                        if (i > 0) {
                            buf.append(str);
                        }
                        if ((o = b.get(i)) != null && o != VOID) {
                            buf.append(7.JS_toString(o));
                        }
                        ++i;
                    }
                    return new JSString(buf.toString());
                }
            });
            this._prototype.set("splice", new JSFunctionCalls2(){

                public Object call(Scope s, Object startObj, Object numObj, Object[] foo) {
                    int i;
                    int start;
                    JSArray a = (JSArray)s.getThis();
                    JSArray n = new JSArray();
                    int n2 = start = startObj == null ? 0 : ((Number)startObj).intValue();
                    if (start < 0) {
                        start = Math.max(0, a._array.size() + start);
                    }
                    start = Math.min(start, a._array.size());
                    int num = numObj == null ? Integer.MAX_VALUE : ((Number)numObj).intValue();
                    for (i = 0; i < num && start < a._array.size(); ++i) {
                        n._array.add(a._array.remove(start));
                    }
                    if (foo != null) {
                        for (i = 0; i < foo.length; ++i) {
                            a._array.add(i + start, foo[i]);
                        }
                    }
                    return n;
                }
            });
            this._prototype.set("slice", new JSFunctionCalls2(){

                public Object call(Scope s, Object startObj, Object numObj, Object[] foo) {
                    int end;
                    int start;
                    JSArray a = (JSArray)s.getThis();
                    JSArray n = new JSArray();
                    int n2 = start = startObj == null ? 0 : ((Number)startObj).intValue();
                    if (start < 0) {
                        start = Math.max(0, a._array.size() + start);
                    }
                    int n3 = end = numObj == null ? Integer.MAX_VALUE : ((Number)numObj).intValue();
                    if (end < 0) {
                        end = Math.max(0, a._array.size() + end);
                    }
                    for (int i = start; i < end && i < a._array.size(); ++i) {
                        n._array.add(a._array.get(i));
                    }
                    return n;
                }
            });
            this._prototype.set("remove", new JSFunctionCalls1(){

                public Object call(Scope s, Object idxObj, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    int idx = ((Number)idxObj).intValue();
                    if (idx >= a._array.size()) {
                        return null;
                    }
                    return a._array.remove(idx);
                }
            });
            this._prototype.set("push", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    if (a == null) {
                        throw new RuntimeException("this shouldn't be possible.  scope id = " + s._id);
                    }
                    a.add(o);
                    return a.size();
                }
            });
            this._prototype.set("unshift", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    if (a == null) {
                        throw new RuntimeException("this shouldn't be possible.  scope id = " + s._id);
                    }
                    a._array.add(0, o);
                    if (foo != null) {
                        for (int i = 0; i < foo.length; ++i) {
                            a._array.add(1 + i, foo[i]);
                        }
                    }
                    return a.size();
                }
            });
            this._prototype.set("__rshift", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    if (a == null) {
                        throw new RuntimeException("this shouldn't be possible.  scope id = " + s._id);
                    }
                    a._array.add(o);
                    if (foo != null) {
                        for (int i = 0; i < foo.length; ++i) {
                            a._array.add(foo[i]);
                        }
                    }
                    return a;
                }
            });
            this._prototype.set("concat", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    if (a == null) {
                        throw new RuntimeException("this shouldn't be possible.  scope id = " + s._id);
                    }
                    if (o == null) {
                        return a;
                    }
                    if (!(o instanceof JSArray)) {
                        throw new RuntimeException("trying to concat a non-array");
                    }
                    a = new JSArray(a);
                    JSArray tempArray = (JSArray)o;
                    for (Object temp : tempArray._array) {
                        a.add(temp);
                    }
                    return a;
                }
            });
            this._prototype.set("filter", new JSFunctionCalls1(){

                public Object call(Scope s, Object fo, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSFunction f = (JSFunction)fo;
                    JSArray n = new JSArray();
                    for (Object o : a._array) {
                        if (!15.JS_evalToBool(f.call(s, o))) continue;
                        n.add(o);
                    }
                    return n;
                }
            });
            this._prototype.set("reduce", new JSFunctionCalls1(){

                public Object call(Scope s, Object fo, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSFunction f = (JSFunction)fo;
                    Object val = null;
                    if (foo != null && foo.length > 0) {
                        val = foo[0];
                    }
                    Integer l = a._array.size();
                    for (int i = 0; i < a._array.size(); ++i) {
                        val = f.call(s, val, a._array.get(i), (Object)i, l);
                    }
                    return val;
                }
            });
            this._prototype.set("reduceRight", new JSFunctionCalls1(){

                public Object call(Scope s, Object fo, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSFunction f = (JSFunction)fo;
                    Object val = null;
                    if (foo != null && foo.length > 0) {
                        val = foo[0];
                    }
                    Integer l = a._array.size();
                    for (int i = a._array.size() - 1; i >= 0; --i) {
                        val = f.call(s, val, a._array.get(i), (Object)i, l);
                    }
                    return val;
                }
            });
            this._prototype.set("unique", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSArray n = new JSArray();
                    HashSet<Object> seen = new HashSet<Object>();
                    for (Object o : a._array) {
                        if (seen.contains(o)) continue;
                        seen.add(o);
                        n.add(o);
                    }
                    return n;
                }
            });
            this._prototype.set("dup", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    return new JSArray(a);
                }
            });
            this._prototype.set("forEach", new JSFunctionCalls1(){

                public Object call(Scope s, Object fo, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSFunction f = (JSFunction)fo;
                    if (f == null) {
                        throw new NullPointerException("forEach needs a function");
                    }
                    for (int i = 0; i < a._array.size(); ++i) {
                        f.call(s, a._array.get(i), (Object)i, a._array.size());
                    }
                    return null;
                }
            });
            this._prototype.set("every", new JSFunctionCalls1(){

                public Object call(Scope s, Object fo, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSFunction f = (JSFunction)fo;
                    for (Object o : a._array) {
                        if (21.JS_evalToBool(f.call(s, o))) continue;
                        return false;
                    }
                    return true;
                }
            });
            this._prototype.set("some", new JSFunctionCalls1(){

                public Object call(Scope s, Object fo, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSFunction f = (JSFunction)fo;
                    for (Object o : a._array) {
                        if (!22.JS_evalToBool(f.call(s, o))) continue;
                        return true;
                    }
                    return false;
                }
            });
            this._prototype.set("map", new JSFunctionCalls1(){

                public Object call(Scope s, Object fo, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSFunction f = (JSFunction)fo;
                    JSArray n = new JSArray();
                    for (Object o : a._array) {
                        n.add(JSArray.fixAndCall(s, f, o));
                    }
                    return n;
                }
            });
            this._prototype.set("collect", this._prototype.get("map"));
            this._prototype.set("collect_ex_", new JSFunctionCalls1(){

                public Object call(Scope s, Object fo, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSFunction f = (JSFunction)fo;
                    for (int i = 0; i < a._array.size(); ++i) {
                        a.set(i, JSArray.fixAndCall(s, f, a._array.get(i)));
                    }
                    return a;
                }
            });
            this._prototype.set("contains", new JSFunctionCalls1(){

                public Object call(Scope s, Object test, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    for (Object o : a._array) {
                        if (!JSInternalFunctions.JS_eq(o, test).booleanValue()) continue;
                        return true;
                    }
                    return false;
                }
            });
            this._prototype.set("include_q_", this._prototype.get("contains"));
            this._prototype.set("indexOf", new JSFunctionCalls1(){

                public Object call(Scope s, Object test, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    int start = 0;
                    if (foo != null && foo.length > 0 && foo[0] instanceof Number) {
                        start = ((Number)foo[0]).intValue();
                    }
                    for (int i = start; i < a._array.size(); ++i) {
                        if (!JSInternalFunctions.JS_eq(test, a._array.get(i)).booleanValue()) continue;
                        return i;
                    }
                    return -1;
                }
            });
            this._prototype.set("lastIndexOf", new JSFunctionCalls1(){

                public Object call(Scope s, Object test, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    int start = a._array.size() - 1;
                    if (foo != null && foo.length > 0 && foo[0] instanceof Number) {
                        start = ((Number)foo[0]).intValue();
                    }
                    if (start >= a._array.size()) {
                        start = a._array.size() - 1;
                    }
                    for (int i = start; i >= 0; --i) {
                        if (!JSInternalFunctions.JS_sheq(test, a._array.get(i)).booleanValue()) continue;
                        return i;
                    }
                    return -1;
                }
            });
            this._prototype.set("sort", new JSFunctionCalls1(){

                public Object call(Scope s, Object func, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    if (func == null) {
                        Collections.sort(a._array, _normalComparator);
                    } else {
                        Collections.sort(a._array, new MyComparator(s, (JSFunction)func));
                    }
                    return a;
                }
            });
            this._prototype.set("__multiAssignment", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    if (foo != null) {
                        for (int i = 0; i < foo.length - 1; i += 2) {
                            JSObject obj = (JSObject)foo[i];
                            obj.set(foo[i + 1], a.get(i / 2));
                        }
                    }
                    return a;
                }
            });
            this._prototype.set("empty_q_", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    return a.isEmpty();
                }
            });
            this._prototype.set("compact", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    JSArray a = (JSArray)s.getThis();
                    JSArray n = new JSArray();
                    for (Object o : a) {
                        if (o == null) continue;
                        n.add(o);
                    }
                    return n;
                }
            });
            this._prototype.set("each", new JSFunctionCalls1(){

                public Object call(Scope s, Object funcObject, Object[] args) {
                    if (funcObject == null) {
                        throw new NullPointerException("each needs a function");
                    }
                    JSFunction func = (JSFunction)funcObject;
                    JSArray a = (JSArray)s.getThis();
                    Object blah = s.getParent().getThis();
                    s.setThis(blah);
                    Boolean old = func.setUsePassedInScopeTL(true);
                    for (int i = 0; i < a._array.size(); ++i) {
                        Object o = a._array.get(i);
                        Object ret = func.call(s, o);
                        if (ret == null) continue;
                        if (ret instanceof Number && ((Number)ret).longValue() == -111L) {
                            --i;
                            continue;
                        }
                        if (!JSInternalFunctions.JS_evalToBool(ret)) break;
                    }
                    func.setUsePassedInScopeTL(old);
                    s.clearThisNormal(null);
                    return null;
                }
            });
            this._prototype.set("length", 0);
            this.set("createLinkedList", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] extra) {
                    return new JSArray(new LinkedList());
                }
            });
            this._prototype.dontEnumExisting();
            this.setProperties("prototype", JSObjectBase.LOCK);
            this.dontEnumExisting();
        }
    }
}

