/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JSArray;
import ed.js.JSBoolean;
import ed.js.JSDict;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSNumber;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Convert;
import ed.js.engine.Scope;
import ed.lang.Language;
import ed.util.Config;
import java.io.File;
import java.util.List;

public class JS
extends Language {
    public static boolean JNI = false;
    public static final boolean DI = false;
    public static final boolean RAW_EXCPETIONS = Config.get().getBoolean("RAWE");

    public JS() {
        super("js");
    }

    public Object eval(Scope scope, String code, boolean[] hasReturn) {
        return scope.eval(code, "eval", hasReturn);
    }

    public static void _debugSI(String name, String place) {
    }

    public static void _debugSIStart(String name) {
    }

    public static void _debugSIDone(String name) {
    }

    public static final int fun() {
        return 17;
    }

    public static boolean bool(Object o) {
        return JSInternalFunctions.JS_evalToBool(o);
    }

    public static final Object eval(String js) {
        JNI = true;
        try {
            Scope s = Scope.getAScope().child();
            Object ret = s.eval(js);
            return ret;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static final String toString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static boolean isBaseObject(Object o) {
        if (o == null) {
            return false;
        }
        return JS.isBaseObject(o.getClass());
    }

    public static boolean isBaseObject(Class c) {
        return c == JSObjectBase.class || c == JSDict.class;
    }

    public static boolean isPrimitive(Object o) {
        return o instanceof Number || o instanceof JSNumber || o instanceof Boolean || o instanceof JSBoolean || o instanceof String || o instanceof JSString;
    }

    public static JSArray getArray(JSObject o, String name) {
        List l = JS.getList(o, name);
        if (l instanceof JSArray) {
            return (JSArray)l;
        }
        return null;
    }

    public static List getList(JSObject o, String name) {
        if (o == null) {
            return null;
        }
        Object v = o.get(name);
        if (v == null) {
            return null;
        }
        if (v instanceof List) {
            return (List)v;
        }
        return null;
    }

    public static Object path(JSObject o, String path) {
        if (o == null) {
            return null;
        }
        if (path == null) {
            return o;
        }
        while (path.length() > 0) {
            int idx = path.indexOf(".");
            if (idx < 0) {
                return o.get(path);
            }
            Object next = o.get(path.substring(0, idx));
            if (next == null) {
                return null;
            }
            if (!(next instanceof JSObject)) {
                return null;
            }
            o = (JSObject)next;
            path = path.substring(idx + 1);
        }
        return o;
    }

    public static Object eval(JSObject o, String funcName, Object ... args) {
        if (o == null) {
            throw new NullPointerException("null object");
        }
        JSFunction f = o.getFunction(funcName);
        if (f == null) {
            throw new NullPointerException("no function named [" + funcName + "]");
        }
        return f.callAndSetThis(null, o, args);
    }

    public static JSDict build(String[] names, Object[] values) {
        JSDict d = new JSDict();
        for (int i = 0; i < names.length; ++i) {
            d.set(names[i], values != null && i < values.length ? values[i] : null);
        }
        return d;
    }

    public static void main(String[] args) throws Exception {
        for (String s : args) {
            if ((s = s.trim()).length() == 0) continue;
            System.out.println("-----");
            System.out.println(s);
            Convert c = new Convert(new File(s));
            c.get().call(Scope.newGlobal().child());
        }
    }
}

