/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Document parse(File f) throws SAXException, IOException {
        return XMLUtil.getBuilder().parse(f);
    }

    public static Document parse(InputStream in) throws SAXException, IOException {
        return XMLUtil.getBuilder().parse(in);
    }

    public static Document parse(String s) throws SAXException, IOException {
        return XMLUtil.parse(new StringBufferInputStream(s));
    }

    public static DocumentBuilder getBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("can't create parser?" + pce);
        }
    }

    public static String toString(Node n) {
        StringBuilder buf = new StringBuilder();
        XMLUtil.append(n, buf, 0);
        return buf.toString();
    }

    public static StringBuilder append(Node n, StringBuilder buf, int level) {
        NodeList children;
        if (n instanceof CharacterData) {
            return XMLUtil._level(buf, level).append(n.getNodeValue()).append("\n");
        }
        XMLUtil._level(buf, level).append("<").append(n.getNodeName());
        NamedNodeMap attr = n.getAttributes();
        if (attr != null) {
            for (int i = 0; i < attr.getLength(); ++i) {
                Node a = attr.item(i);
                buf.append(" ").append(a.getNodeName()).append("=\"").append(a.getNodeValue()).append("\" ");
            }
        }
        if ((children = n.getChildNodes()) == null || children.getLength() == 0) {
            return buf.append("/>\n");
        }
        buf.append(">\n");
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            XMLUtil.append(c, buf, level + 1);
        }
        return XMLUtil._level(buf, level).append("</").append(n.getNodeName()).append(">\n");
    }

    static StringBuilder _level(StringBuilder buf, int level) {
        for (int i = 0; i < level; ++i) {
            buf.append(" ");
        }
        return buf;
    }
}

