/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

public final class StringUtil {
    public static int indexOf(String big, String small, boolean ignoreCase, int start) {
        for (int i = start; i < big.length() - small.length(); ++i) {
            if (!big.regionMatches(ignoreCase, i, small, 0, small.length())) continue;
            return i;
        }
        return -1;
    }

    public static int count(String big, String small) {
        int c = 0;
        int idx = 0;
        while ((idx = big.indexOf(small, idx)) >= 0) {
            ++c;
            idx += small.length();
        }
        return c;
    }

    public static final String replace(String str, String from, String to) {
        int idx;
        if (from == null || from.length() == 0) {
            return str;
        }
        StringBuffer buf = null;
        int start = 0;
        while ((idx = str.indexOf(from, start)) >= 0) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(str.substring(start, idx));
            buf.append(to);
            start = idx + from.length();
        }
        if (buf == null) {
            return str;
        }
        buf.append(str.substring(start));
        return buf.toString();
    }

    public static boolean isDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getStackTrace(Throwable t) {
        StringBuilder buf = new StringBuilder();
        buf.append(t).append("\n");
        for (StackTraceElement e : t.getStackTrace()) {
            buf.append("  ").append(e).append("\n");
        }
        return buf.toString();
    }
}

