/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.TestCase;
import ed.util.ObjectPath;
import ed.util.SeenPath;
import java.util.List;
import org.testng.annotations.Test;

public class SeenPathTest
extends TestCase {
    @Test
    public void testSanity1() {
        SeenPath p = new SeenPath();
        Object from = new Object();
        Object to = new Object();
        SeenPathTest.assertTrue(p.shouldVisit(to, from));
        SeenPathTest.assertFalse(p.shouldVisit(to, from));
        SeenPathTest.assertEquals(1, ((List)p.get(to)).size());
        SeenPathTest.assertFalse(p.shouldVisit(to, new Object()));
        SeenPathTest.assertEquals(2, ((List)p.get(to)).size());
        SeenPathTest.assertTrue(p.shouldVisit(new Object(), from));
    }

    @Test
    public void testSanity2() {
        SeenPath p = new SeenPath();
        Object from = new Object();
        Object to = new Object();
        p.visited(to);
        SeenPathTest.assertEquals(1, ((List)p.get(to)).size());
        assert (((List)p.get(to)).get(0) instanceof SeenPath.Unknown);
        SeenPathTest.assertFalse(p.shouldVisit(to, from));
        SeenPathTest.assertEquals(1, ((List)p.get(to)).size());
        assert (from == ((List)p.get(to)).get(0));
    }

    @Test
    public void testBasicPathing1() {
        SeenPath p = new SeenPath();
        String a = "a";
        String b = "b";
        String c = "c";
        p.shouldVisit(b, a);
        p.shouldVisit(c, b);
        ObjectPath lst = p.path(a, c);
        SeenPathTest.assertEquals(1, lst.size());
        SeenPathTest.assertTrue(b == lst.get(0));
    }

    @Test
    public void testLoop1() {
        SeenPath p = new SeenPath();
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        p.shouldVisit(c, d);
        p.shouldVisit(b, a);
        p.shouldVisit(c, b);
        p.shouldVisit(d, c);
        p.path(a, d);
    }

    public static void main(String[] args) {
        new SeenPathTest().runConsole();
    }
}

