/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.js.JSFunction;
import ed.js.engine.Scope;
import ed.util.ScriptTestInstance;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.testng.annotations.Factory;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptTestFactory {
    public static List<String> excludeList = new ArrayList<String>();
    public static String baseDir = "";

    static void addExcludeFiles(File f) throws IOException {
        if (f.isDirectory()) {
            for (File aFile : f.listFiles()) {
                ScriptTestFactory.addExcludeFiles(aFile);
            }
        } else {
            excludeList.add(f.getCanonicalPath());
        }
    }

    @Parameters(value={"test-class", "dir-name", "file-ending", "inc-regex", "ex-regex", "recursive"})
    @Factory
    public Object[] createTestInstances(String testClassName, String dirName, String fileEnding, @Optional(value="") String inclusionRegex, @Optional(value="") String exclusionRegex, @Optional(value="false") String recursive) throws Exception {
        ArrayList<ScriptTestInstance> list = new ArrayList<ScriptTestInstance>();
        if (testClassName == null || testClassName.length() == 0) {
            list.add(new FrameworkMisconfigTestInstance("test class name unspecified"));
            return list.toArray();
        }
        try {
            ScriptTestInstance i = (ScriptTestInstance)Class.forName(testClassName).newInstance();
        }
        catch (ClassCastException cce) {
            list.add(new FrameworkMisconfigTestInstance("specified test class not a ScriptTestInstance?" + cce));
            return list.toArray();
        }
        if (dirName == null || dirName.length() == 0) {
            list.add(new FrameworkMisconfigTestInstance("test directory unspecified"));
            return list.toArray();
        }
        if (fileEnding == null || fileEnding.length() == 0 && inclusionRegex.length() == 0) {
            list.add(new FrameworkMisconfigTestInstance("no inclusion criteria given"));
            return list.toArray();
        }
        File dir = new File(dirName);
        if (!dir.exists()) {
            list.add(new FrameworkMisconfigTestInstance("test directory doesn't exist : " + dir));
            return list.toArray();
        }
        Pattern inPattern = null;
        Pattern exPattern = null;
        if (inclusionRegex != null && inclusionRegex.length() > 0) {
            inPattern = Pattern.compile(inclusionRegex);
        }
        if (exclusionRegex != null && exclusionRegex.length() > 0) {
            exPattern = Pattern.compile(exclusionRegex);
        }
        if (recursive.equals("true")) {
            this.addFilesRecursively(dir, list, testClassName, fileEnding, inPattern, exPattern);
        } else {
            for (File f : dir.listFiles()) {
                this.addIfValid(f, list, testClassName, fileEnding, inPattern, exPattern);
            }
        }
        return list.toArray();
    }

    public void addFilesRecursively(File dir, List<ScriptTestInstance> list, String testClassName, String fileEnding, Pattern inPattern, Pattern exPattern) throws Exception {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.addFilesRecursively(f, list, testClassName, fileEnding, inPattern, exPattern);
                continue;
            }
            this.addIfValid(f, list, testClassName, fileEnding, inPattern, exPattern);
        }
    }

    public void addIfValid(File f, List<ScriptTestInstance> list, String testClassName, String fileEnding, Pattern inPattern, Pattern exPattern) throws Exception {
        boolean include = true;
        if (f.toString().endsWith(fileEnding)) {
            if (inPattern != null) {
                include = inPattern.matcher(f.toString()).matches();
            }
            if (exPattern != null && exPattern.matcher(f.toString()).matches()) {
                System.out.println("JSTestFactory : regexp exclusion of " + f.toString());
                include = false;
            }
            if (excludeList.contains(f.getCanonicalPath())) {
                include = false;
            }
            if (include) {
                ScriptTestInstance testInstance = (ScriptTestInstance)Class.forName(testClassName).newInstance();
                testInstance.setTestScriptFile(f);
                list.add(testInstance);
            }
        }
    }

    static {
        try {
            String root = System.getProperty("TESTNG:CODE_ROOT", "/data");
            baseDir = new File(root + "/qa/modules/mozilla/").getCanonicalPath();
            Scanner sc = new Scanner(new File(baseDir + File.separator + "exclude"));
            while (sc.hasNext()) {
                String s = sc.next();
                if (s.startsWith("#")) {
                    sc.nextLine();
                    continue;
                }
                ScriptTestFactory.addExcludeFiles(new File(baseDir + File.separator + s));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class FrameworkMisconfigTestInstance
    implements ScriptTestInstance {
        private String msg;

        FrameworkMisconfigTestInstance(String m) {
            this.msg = "FRAMEWORK CONFIG ERROR  : " + m;
        }

        @Test
        public void test() throws Exception {
            throw new Exception(this.msg);
        }

        public JSFunction convert() throws Exception {
            return null;
        }

        public void preTest(Scope s) throws Exception {
        }

        public void setTestScriptFile(File f) {
        }

        public void validateOutput(Scope s) throws Exception {
        }
    }
}

