/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.util.FastStringMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectPath
extends ArrayList {
    final List<LoopInfo> _loops = new ArrayList<LoopInfo>();
    final List<EndInfo> _ends = new ArrayList<EndInfo>();

    public Object removeLast() {
        return this.remove(this.size() - 1);
    }

    public void addEndOfPath(Throwable allocated) {
        this._ends.add(new EndInfo(allocated));
    }

    public void foundLoop(Object what) {
        LoopInfo li = new LoopInfo(what);
        String s = li._snapshot.substring(0, li._snapshot.length() - 1);
        for (LoopInfo old : this._loops) {
            if (!old._snapshot.startsWith(s)) continue;
            return;
        }
        this._loops.add(li);
    }

    public RuntimeException getDebugException() {
        throw new RuntimeException("can't find path.  loops : " + this._loops + " ends : " + this._ends);
    }

    public void debug() {
        System.out.println("loops");
        for (LoopInfo l : this._loops) {
            l.debug();
        }
        System.out.println("ends");
        for (EndInfo e : this._ends) {
            e.debug();
        }
    }

    public static String pathElementsToString(Iterable i) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (Object o : i) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(ObjectPath.pathElementToString(o));
            buf.append("]");
        }
        return buf.toString();
    }

    public static String pathElementToString(Object o) {
        if (o == null) {
            return "null";
        }
        String s = o.getClass().getName();
        if (o instanceof Scope || o instanceof Number || o instanceof JSString || o instanceof String) {
            s = s + "(" + o + ")";
        }
        if (o instanceof Collection) {
            s = s + "(size=" + ((Collection)o).size() + ")";
        }
        if (o instanceof FastStringMap) {
            s = s + "(size=" + ((FastStringMap)o).size() + ")";
        }
        if (o instanceof JSObjectBase) {
            s = s + "(" + ((JSObjectBase)o)._getName() + ")";
        }
        s = s + ":" + System.identityHashCode(o);
        return s;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.size() * 20);
        buf.append("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(ObjectPath.pathElementToString(this.get(i)));
        }
        buf.append("]");
        return buf.toString();
    }

    abstract class Info {
        final String _snapshot;

        Info() {
            this._snapshot = ObjectPath.this.toString();
        }

        abstract void debug();
    }

    class EndInfo
    extends Info {
        final Throwable _t;

        EndInfo(Throwable t) {
            this._t = t;
        }

        void debug() {
            System.out.println("\t" + this._snapshot);
            if (this._t != null) {
                this._t.printStackTrace();
            }
        }
    }

    class LoopInfo
    extends Info {
        final Object _where;

        LoopInfo(Object where) {
            this._where = where;
        }

        void debug() {
            System.out.println("\t" + this._snapshot + " where:" + ObjectPath.pathElementToString(this._where));
        }
    }
}

