/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.TestCase;
import ed.util.MemUtil;
import org.testng.annotations.Test;

public class MemUtilTest
extends TestCase {
    @Test
    public void testJavaIsGC() {
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("2369.623: [GC [PSYoungGen: 253491K->57715K(270720K)] 662375K->492170K(760896K), 0.1937260 secs] [Times: user=0.24 sys=0.00, real=0.20 secs] "));
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("2378.656: [GC [PSYoungGen: 259315K->53474K(271616K)] 693770K->491671K(761792K), 0.1463140 secs] [Times: user=0.16 sys=0.00, real=0.14 secs] "));
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("2388.453: [GC [PSYoungGen: 257442K->56577K(271616K)] 695639K->498343K(761792K), 0.1480230 secs] [Times: user=0.17 sys=0.00, real=0.14 secs] "));
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("2394.839: [GC [PSYoungGen: 260545K->52847K(272960K)] 702311K->509225K(763136K), 0.1738920 secs] [Times: user=0.19 sys=0.00, real=0.18 secs] "));
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("2395.013: [Full GC [PSYoungGen: 52847K->0K(272960K)] [PSOldGen: 456378K->287193K(508160K)] 509225K->287193K(781120K) [PSPermGen: 44209K->44209K(44992K)], 0.8087710 secs] [Times: user=0.81 sys=0.00, real=0.80 secs] "));
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("[GC [PSYoungGen: 260545K->52847K(272960K)] 702311K->509225K(763136K), 0.1738920 secs] [Times: user=0.19 sys=0.00, real=0.18 secs] "));
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("[Full GC [PSYoungGen: 52847K->0K(272960K)] [PSOldGen: 456378K->287193K(508160K)] 509225K->287193K(781120K) [PSPermGen: 44209K->44209K(44992K)], 0.8087710 secs] [Times: user=0.81 sys=0.00, real=0.80 secs] "));
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("46954.065: [Full GC [PSYoungGen: 100608K->100594K(225984K)] [PSOldGen: 819199K->819199K(819200K)] 919807K->919794K(1045184K) [PSPermGen: 46936K->46936K(47232K)], 1.8832360 secs]"));
        MemUtilTest.assertTrue(MemUtil.GCLine.isGCLine("105.350: [GC [PSYoungGen: 106006K->25000K(145024K)] 228802K->167810K(1874496K), 0.0308960 secs]"));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("Asdasd"));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("Exception in thread \"ThreadPool.MyThread:HttpServer-main:2\" java.lang.OutOfMemoryError: GC overhead limit exceeded\""));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("Caused by: java.lang.OutOfMemoryError: GC overhead limit exceeded"));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("java.lang.OutOfMemoryError: GC overhead limit exceeded"));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("java.lang.OutOfMemoryError: GC overhead limit exceeded"));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("\"GC task thread#0 (ParallelGC)\" prio=10 tid=0x000000004011d800 nid=0x58c7 runnable "));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("\"GC task thread#1 (ParallelGC)\" prio=10 tid=0x000000004011ec00 nid=0x58c8 runnable "));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("[11/02/2008 01:53:30.475 EST] ThreadPool.MyThread:HttpServer-main:15 || clusterstock:www.slow INFO >> /Gannett-Co-GCI-stock-financial-analysis.html 2615ms"));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("Exception in thread \"ThreadPool.MyThread:HttpServer-main:29\" java.lang.OutOfMemoryError: GC overhead limit exceeded"));
        MemUtilTest.assertFalse(MemUtil.GCLine.isGCLine("java.lang.OutOfMemoryError: GC overhead limit exceeded"));
    }

    @Test
    public void testParse1() {
        this._testParse("2394.839: [GC [PSYoungGen: 260545K->52847K(272960K)] 702311K->509225K(763136K), 0.1738920 secs] [Times: user=0.19 sys=0.00, real=0.18 secs] ", 2394839L, false, 180L);
        this._testParse("[Full GC [PSYoungGen: 52847K->0K(272960K)] [PSOldGen: 456378K->287193K(508160K)] 509225K->287193K(781120K) [PSPermGen: 44209K->44209K(44992K)], 0.8087710 secs] [Times: user=0.81 sys=0.00, real=0.80 secs] ", -1L, true, 800L);
        this._testParse("7.12: [Full GC [PSYoungGen: 52847K->0K(272960K)] [PSOldGen: 456378K->287193K(508160K)] 509225K->287193K(781120K) [PSPermGen: 44209K->44209K(44992K)], 0.8087710 secs] [Times: user=0.81 sys=0.00, real=0.80 secs] ", 7120L, true, 800L);
        this._testParse("7.012: [Full GC [PSYoungGen: 52847K->0K(272960K)] [PSOldGen: 456378K->287193K(508160K)] 509225K->287193K(781120K) [PSPermGen: 44209K->44209K(44992K)], 0.8087710 secs] [Times: user=0.81 sys=0.00, real=0.80 secs] ", 7012L, true, 800L);
    }

    @Test
    public void testParse2() {
        this._testParse("[GC [PSYoungGen: 260545K->52847K(272960K)] 702311K->509225K(763136K), 0.1738920 secs] [Times: user=0.19 sys=0.00, real=0.18 secs] ", -1L, false, 180L);
    }

    @Test
    public void test15parse() {
        this._testParse("105.350: [GC [PSYoungGen: 106006K->25000K(145024K)] 228802K->167810K(1874496K), 0.0308960 secs]", 105350L, false, 30L);
        this._testParse("405.910: [Full GC [PSYoungGen: 34126K->0K(145920K)] [PSOldGen: 1740897K->1359078K(1751296K)] 1775023K->1359078K(1897216K) [PSPermGen: 22334K->22173K(45568K)], 3.4769290 secs]", 405910L, true, 3476L);
    }

    @Test
    public void testparse3() {
        this._testParse("120.944: [Full GC [PSYoungGen: 482K->0K(80768K)] [PSOldGen: 199383K->184138K(204800K)] 199865K->184138K(285568K) [PSPermGen: 39425K->39425K(47168K)], 0.6940380 secs]", 120944L, true, 694L);
    }

    void _testParse(String line, long when, boolean full, long howLong) {
        MemUtil.GCLine l = MemUtil.GCLine.parse(line);
        assert (l != null);
        MemUtilTest.assertEquals(when, l.when());
        MemUtilTest.assertEquals(full, (Object)l.full());
        MemUtilTest.assertEquals(howLong, l.howLong());
    }

    @Test
    public void testGCStream1() {
        MemUtil.GCStream s = new MemUtil.GCStream();
        MemUtilTest.assertEquals(0.0, (Object)s.fullGCPercentage());
        s.add(new MemUtil.GCLine(0L, false, 5L));
        s.add(new MemUtil.GCLine(1000L, false, 5L));
        s.add(new MemUtil.GCLine(2000L, false, 5L));
        s.add(new MemUtil.GCLine(3000L, false, 5L));
        s.add(new MemUtil.GCLine(4000L, false, 5L));
        s.add(new MemUtil.GCLine(5000L, false, 5L));
        MemUtilTest.assertEquals(0.0, (Object)s.fullGCPercentage());
    }

    @Test
    public void testGCStream2() {
        MemUtil.GCStream s = new MemUtil.GCStream();
        MemUtilTest.assertEquals(0.0, (Object)s.fullGCPercentage());
        s.add(new MemUtil.GCLine(0L, true, 500L));
        s.add(new MemUtil.GCLine(1000L, true, 500L));
        s.add(new MemUtil.GCLine(2000L, true, 500L));
        s.add(new MemUtil.GCLine(3000L, true, 500L));
        s.add(new MemUtil.GCLine(4000L, true, 500L));
        MemUtilTest.assertEquals(0.0, s.fullGCPercentage(), 0.0);
        s.add(new MemUtil.GCLine(5000L, true, 500L));
        MemUtilTest.assertEquals(0.6, s.fullGCPercentage(), 0.0);
    }

    @Test
    public void testGCStream3() {
        MemUtil.GCStream s = new MemUtil.GCStream();
        MemUtilTest.assertEquals(0.0, (Object)s.fullGCPercentage());
        s.add(new MemUtil.GCLine(0L, true, 500L));
        s.add(new MemUtil.GCLine(1000L, false, 500L));
        s.add(new MemUtil.GCLine(2000L, true, 500L));
        s.add(new MemUtil.GCLine(3000L, false, 500L));
        s.add(new MemUtil.GCLine(4000L, true, 500L));
        MemUtilTest.assertEquals(0.0, s.fullGCPercentage(), 0.0);
        s.add(new MemUtil.GCLine(5000L, true, 500L));
        MemUtilTest.assertEquals(0.4, s.fullGCPercentage(), 0.0);
    }

    @Test
    public void testGCStream4() {
        MemUtil.GCStream s = new MemUtil.GCStream();
        MemUtilTest.assertEquals(0.0, (Object)s.fullGCPercentage());
        long time = 1000L;
        for (int i = 0; i < 100; ++i) {
            s.add(new MemUtil.GCLine(time, false, 100L));
            time += 1000L;
        }
        MemUtilTest.assertEquals(0.0, (Object)s.fullGCPercentage());
        s.add(new MemUtil.GCLine(time, true, 2000L));
        MemUtilTest.assertEquals(0.105, s.fullGCPercentage(), 0.01);
    }

    @Test
    public void testGCStream5() {
        MemUtil.GCStream s = new MemUtil.GCStream();
        MemUtilTest.assertTrue(s.add("1313.919: [GC [PSYoungGen: 324803K->51506K(343744K)] 864899K->594837K(926976K), 0.1065260 secs]"));
        MemUtilTest.assertTrue(s.add("1319.303: [GC [PSYoungGen: 330790K->35957K(344448K)] 874121K->579345K(927680K), 0.0739770 secs]"));
        MemUtilTest.assertTrue(s.add("1321.351: [GC [PSYoungGen: 315246K->34913K(343232K)] 858633K->578404K(926464K), 0.0632070 secs]"));
        MemUtilTest.assertTrue(s.add("1325.257: [GC [PSYoungGen: 314721K->27079K(343936K)] 858212K->570594K(927168K), 0.0537650 secs]"));
        MemUtilTest.assertTrue(s.add("1327.040: [GC [PSYoungGen: 306887K->31759K(344704K)] 850402K->575290K(927936K), 0.0658280 secs]"));
        MemUtilTest.assertTrue(s.add("1332.575: [GC [PSYoungGen: 312463K->42887K(323648K)] 855994K->586450K(906880K), 0.0807930 secs]"));
        MemUtilTest.assertTrue(s.add("1335.874: [GC [PSYoungGen: 323591K->32320K(344896K)] 867154K->580044K(928128K), 0.0682390 secs]"));
        MemUtilTest.assertTrue(s.add("1342.048: [GC [PSYoungGen: 314624K->31640K(344128K)] 862348K->579711K(927360K), 0.0645430 secs]"));
        MemUtilTest.assertTrue(s.add("1342.462: [GC [PSYoungGen: 313944K->43344K(346880K)] 862015K->591536K(930112K), 0.0662180 secs]"));
        MemUtilTest.assertTrue(s.add("1342.938: [GC [PSYoungGen: 329168K->59715K(345600K)] 877360K->607949K(928832K), 0.0968700 secs]"));
        MemUtilTest.assertTrue(s.add("1343.479: [GC [PSYoungGen: 345539K->63991K(313344K)] 893773K->634916K(896576K), 0.1513180 secs]"));
        MemUtilTest.assertTrue(s.add("1344.076: [GC [PSYoungGen: 313335K->80121K(329472K)] 884260K->660739K(912704K), 0.1366180 secs]"));
        MemUtilTest.assertTrue(s.add("1344.213: [Full GC [PSYoungGen: 80121K->6958K(329472K)] [PSOldGen: 580618K->583232K(672064K)] 660739K->590190K(1001536K) [PSPermGen: 56203K->56203K(59392K)], 1.9110120 secs]"));
        MemUtilTest.assertEquals(0.076, s.fullGCPercentage(), 0.01);
        MemUtilTest.assertTrue(s.add("1354.213: [Full GC [PSYoungGen: 80121K->6958K(329472K)] [PSOldGen: 580618K->583232K(672064K)] 660739K->590190K(1001536K) [PSPermGen: 56203K->56203K(59392K)], 6.9110120 secs]"));
        MemUtilTest.assertEquals(0.407, s.fullGCPercentage(), 0.01);
        MemUtilTest.assertTrue(s.add("1364.213: [Full GC [PSYoungGen: 80121K->6958K(329472K)] [PSOldGen: 580618K->583232K(672064K)] 660739K->590190K(1001536K) [PSPermGen: 56203K->56203K(59392K)], 6.9110120 secs]"));
        MemUtilTest.assertEquals(0.709, s.fullGCPercentage(), 0.01);
        MemUtilTest.assertTrue(s.add("1374.213: [Full GC [PSYoungGen: 80121K->6958K(329472K)] [PSOldGen: 580618K->583232K(672064K)] 660739K->590190K(1001536K) [PSPermGen: 56203K->56203K(59392K)], 6.9110120 secs]"));
        MemUtilTest.assertEquals(1.036, s.fullGCPercentage(), 0.01);
    }

    public static void main(String[] args) {
        new MemUtilTest().runConsole();
    }
}

