/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.lang.StackTraceHolder;
import ed.util.CircularList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemUtil {
    public static final long BIT = 1L;
    public static final long KBIT = 1024L;
    public static final long MBIT = 0x100000L;
    public static final long GBIT = 0x40000000L;
    public static final long BYTE = 1L;
    public static final long KBYTE = 1024L;
    public static final long MBYTE = 0x100000L;
    public static final long GBYTE = 0x40000000L;

    public static final synchronized void checkMemoryAndHalt(String location, OutOfMemoryError oom, MemHaltDisplay display) {
        long before = MemUtil.bytesAvailable();
        System.gc();
        System.gc();
        System.gc();
        long after = MemUtil.bytesAvailable();
        if (after < 0x6400000L || after - before < 0x6400000L) {
            try {
                System.err.print("OutOfMemoryError in " + location + " - not enough free, so dying.");
                System.err.println("before : " + before / 0x100000L);
                System.err.println("after : " + after / 0x100000L);
                StackTraceHolder.getInstance().fix(oom);
                oom.printStackTrace();
                if (display != null) {
                    display.printMemInfo();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Runtime.getRuntime().halt(-3);
        }
    }

    public static final int bytesToMB(long bytes) {
        return (int)(bytes /= 0x100000L);
    }

    public static final long bytesAvailable() {
        Runtime r = Runtime.getRuntime();
        return r.maxMemory() - r.totalMemory() + r.freeMemory();
    }

    public static String getMemInfo(boolean gc) {
        if (gc) {
            System.gc();
        }
        Runtime r = Runtime.getRuntime();
        StringBuilder buf = new StringBuilder();
        buf.append("max   : ").append(MemUtil.bytesToMB(r.maxMemory())).append("\n");
        buf.append("total : ").append(MemUtil.bytesToMB(r.totalMemory())).append("\n");
        buf.append("free  : ").append(MemUtil.bytesToMB(r.freeMemory())).append("\n");
        buf.append("used  : ").append(MemUtil.bytesToMB(r.totalMemory() - r.freeMemory())).append("\n");
        return buf.toString();
    }

    public static String gc() {
        long before = MemUtil.bytesAvailable();
        System.gc();
        long after = MemUtil.bytesAvailable();
        return "before " + before + ", after " + after + ", break " + Runtime.getRuntime().totalMemory();
    }

    public static class GCStream {
        final CircularList<GCLine> _last = new CircularList(20, true);

        public boolean add(String line) {
            GCLine l = GCLine.parse(line);
            if (l == null) {
                return false;
            }
            this.add(l);
            return true;
        }

        public void reset() {
            this._last.clear();
        }

        public void add(GCLine line) {
            this._last.add(line);
        }

        public int fullGCsInARow() {
            GCLine l;
            int size = this._last.size();
            int num = 0;
            for (int i = 0; i < size && (l = this._last.get(i)).full(); ++i) {
                ++num;
            }
            return num;
        }

        public double fullGCPercentage() {
            GCLine l;
            double end;
            int size = this._last.size();
            if (size < 6) {
                return 0.0;
            }
            double start = end = (double)this._last.get(0).when();
            double time = 0.0;
            for (int i = 0; i < size && !((double)(l = this._last.get(i)).when() > end) && !(end - (double)l.when() > 27000.0); ++i) {
                start = l.when();
                if (!l.full()) continue;
                time += (double)l.howLong();
            }
            return time / (end - start);
        }
    }

    public static class GCLine {
        final String _line;
        final long _when;
        final boolean _full;
        final long _howLong;
        static final Pattern[] _howLongPatterns = new Pattern[]{Pattern.compile("real=(\\d+\\.\\d+)\\s*secs"), Pattern.compile("(\\d+\\.\\d+)\\s*secs")};

        private GCLine(String line) {
            this._line = line;
            boolean bl = this._full = line.indexOf("[Full GC ") >= 0;
            if (Character.isDigit(line.charAt(0))) {
                StringBuilder num = new StringBuilder();
                while (true) {
                    char c = line.charAt(0);
                    line = line.substring(1);
                    if (c == ':' || c == ' ') break;
                    num.append(c);
                }
                this._when = (long)(Double.parseDouble(num.toString()) * 1000.0);
                line = line.trim();
            } else {
                this._when = -1L;
            }
            String howLongString = null;
            for (int i = 0; i < _howLongPatterns.length; ++i) {
                Matcher m = _howLongPatterns[i].matcher(line);
                if (!m.find()) continue;
                howLongString = m.group(1);
                break;
            }
            this._howLong = howLongString == null ? -1L : (long)(Double.parseDouble(howLongString) * 1000.0);
        }

        public GCLine(long when, boolean full, long howLong) {
            this._line = null;
            this._when = when;
            this._full = full;
            this._howLong = howLong;
        }

        public static boolean isGCLine(String line) {
            int idx = line.indexOf("[GC ");
            if (idx < 0) {
                idx = line.indexOf("[Full GC ");
            }
            return idx >= 0 && idx <= 50;
        }

        public static GCLine parse(String line) {
            if (!GCLine.isGCLine(line)) {
                return null;
            }
            return new GCLine(line);
        }

        public long when() {
            return this._when;
        }

        public long howLong() {
            return this._howLong;
        }

        public boolean full() {
            return this._full;
        }
    }

    public static interface MemHaltDisplay {
        public void printMemInfo();
    }
}

