/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.js.JSObjectSize;
import ed.util.SeenPath;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FastStringMap
implements Map<String, Object> {
    private int _size = 0;
    private MyEntry[] _data;
    private int _maxChainLength = 1;
    private boolean _slow = false;

    public FastStringMap() {
        this(16);
    }

    public FastStringMap(int initSize) {
        this._data = new MyEntry[initSize];
    }

    @Override
    public Object put(String key, Object value) {
        return this.put(key.hashCode(), key, value);
    }

    public Object put(int hash, String key, Object value) {
        MyEntry e = this._getEntry(hash, key, true);
        Object old = e._value;
        e._value = value;
        if (e._deleted) {
            e._deleted = false;
            ++this._size;
        }
        return old;
    }

    @Override
    public Object get(Object keyObj) {
        return this.get(keyObj.hashCode(), keyObj.toString());
    }

    public Object get(String key) {
        return this.get(key.hashCode(), key);
    }

    public Object get(int hash, String key) {
        MyEntry e = this._getEntry(hash, key, false, this._data, null);
        if (e == null || e._deleted) {
            return null;
        }
        return e.getValue();
    }

    @Override
    public Object remove(Object keyObj) {
        return this.remove(keyObj.hashCode(), keyObj.toString());
    }

    public Object remove(String key) {
        return this.remove(key.hashCode(), key);
    }

    public Object remove(int hash, String key) {
        MyEntry e = this._getEntry(hash, key, false);
        if (e == null || e._deleted) {
            return null;
        }
        --this._size;
        e._deleted = true;
        Object old = e._value;
        e._value = null;
        return old;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(key.hashCode(), key.toString());
    }

    public boolean containsKey(String key) {
        return this.containsKey(key.hashCode(), key);
    }

    public boolean containsKey(int hash, String key) {
        MyEntry e = this._getEntry(hash, key, false, this._data, null);
        return e != null && !e._deleted;
    }

    @Override
    public Set<String> keySet() {
        return this.keySet(false);
    }

    public Set<String> keySet(boolean myCopy) {
        HashSet<String> s = new HashSet<String>(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            MyEntry e = this._data[i];
            if (e == null || e._deleted) continue;
            s.add(e._key);
        }
        return s;
    }

    public void debug() {
        StringBuilder buf = new StringBuilder();
        this.debug(buf);
        System.out.println(buf);
    }

    public void debug(StringBuilder a) {
        a.append("[ ");
        for (int i = 0; i < this._data.length; ++i) {
            if (i > 0) {
                a.append(" , ");
            }
            if (this._data[i] == null || this._data[i]._deleted) continue;
            a.append("\"").append(this._data[i]._key).append("\" ");
        }
        a.append("]");
    }

    @Override
    public void clear() {
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = null;
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == null || this._data[i]._deleted) continue;
            set.add(this._data[i]);
        }
        return set;
    }

    private MyEntry _getEntry(int hash, String key, boolean create) {
        if (key == null) {
            throw new NullPointerException("key is null ");
        }
        MyEntry e;
        while ((e = this._getEntry(hash, key, create, this._data, null)) == null && create) {
            this.grow();
        }
        return e;
    }

    int _indexFor(int h, int max) {
        if (this._slow) {
            if (h < 0) {
                h *= -1;
            }
            return h % max;
        }
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h &= max - 1;
    }

    private final MyEntry _getEntry(int hash, String key, boolean create, MyEntry[] data, MyEntry toInsert) {
        int cur = this._indexFor(hash, data.length);
        for (int z = 0; z < this._maxChainLength; ++z) {
            if (data[cur] == null) {
                if (!create) {
                    return null;
                }
                if (toInsert == null) {
                    ++this._size;
                    data[cur] = new MyEntry(hash, key);
                    return data[cur];
                }
                data[cur] = toInsert;
                return data[cur];
            }
            if (data[cur].equals(hash, key)) {
                return data[cur];
            }
            if (++cur != data.length) continue;
            cur = 0;
        }
        return null;
    }

    private void grow() {
        this.grow((int)((double)this._data.length * 1.5));
    }

    private void grow(int size) {
        ++this._maxChainLength;
        block0: for (int z = 0; z < 20; ++z) {
            if (size > 1000) {
                this._slow = true;
            }
            MyEntry[] newData = new MyEntry[size];
            for (int i = 0; i < this._data.length; ++i) {
                MyEntry e = this._data[i];
                if (e == null || e._deleted) continue;
                MyEntry n = this._getEntry(e._hash, e._key, true, newData, e);
                if (n == null) {
                    if (z % 2 == 0) {
                        size = (int)((double)size * 1.5);
                        continue block0;
                    }
                    ++this._maxChainLength;
                    continue block0;
                }
                if (n == e) continue;
                throw new RuntimeException("something broke");
            }
            this._data = newData;
            return;
        }
        throw new RuntimeException("grow failed");
    }

    public long approxSize(SeenPath seen) {
        if (seen == null) {
            seen = new SeenPath();
        }
        seen.visited(this);
        long size = 104L;
        for (int i = 0; i < this._data.length; ++i) {
            MyEntry e = this._data[i];
            if (e == null) continue;
            size += 24L;
            size += JSObjectSize.size((Object)e._key, (SeenPath)seen, (Object)this);
            size += JSObjectSize.size((Object)e._value, (SeenPath)seen, (Object)this);
        }
        return size;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    public String toString() {
        return "FastStringMap:" + System.identityHashCode(this);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> other) {
        if (other == null || other.size() == 0) {
            return;
        }
        for (String string : other.keySet()) {
            this.put(string, other.get(string));
        }
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MyEntry
    implements Map.Entry<String, Object> {
        final int _hash;
        final String _key;
        private Object _value;
        private boolean _deleted = false;

        MyEntry(int hash, String key) {
            this._hash = hash;
            this._key = key;
        }

        public boolean equals(int hash, String key) {
            return this._hash == hash && this._key.equals(key);
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public int hashCode() {
            return this._hash;
        }

        @Override
        public Object setValue(Object value) {
            Object old = this._value;
            this._value = value;
            return old;
        }

        public String toString() {
            return this._key + ":" + this._value;
        }
    }
}

