/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.io.ByteBufferFactory;
import ed.util.WatchedSimplePool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBufferPool
extends WatchedSimplePool<ByteBuffer>
implements ByteBufferFactory {
    final int _size;
    final ByteOrder _order;

    public ByteBufferPool(String name, int maxToKeep, int size) {
        this(name, maxToKeep, size, null);
    }

    public ByteBufferPool(String name, int maxToKeep, int size, ByteOrder order) {
        super("ByteBufferPool-" + name, maxToKeep, -1);
        this._size = size;
        this._order = order;
    }

    @Override
    public ByteBuffer createNew() {
        ByteBuffer bb = ByteBuffer.allocateDirect(this._size);
        if (this._order != null) {
            bb.order(this._order);
        }
        return bb;
    }

    @Override
    public boolean ok(ByteBuffer buf) {
        buf.position(0);
        buf.limit(buf.capacity());
        return true;
    }

    @Override
    protected long memSize(ByteBuffer buf) {
        return this._size;
    }
}

