/*
 * Decompiled with CFR 0.152.
 */
package ed.log;

import ed.js.JSDate;
import ed.log.Appender;
import ed.log.Event;
import ed.log.EventFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class DailyFileAppender
implements Appender {
    final File _dir;
    final String _base;
    final EventFormatter _formatter;
    private long _nextSwitch = 0L;
    private PrintStream _printStream;

    public DailyFileAppender(String base) {
        this(null, base);
    }

    public DailyFileAppender(File dir, String base) {
        this(dir, base, new EventFormatter.DefaultEventFormatter());
    }

    public DailyFileAppender(File dir, String base, EventFormatter formatter) {
        if (dir == null) {
            dir = new File("logs/");
        }
        this._dir = dir;
        this._dir.mkdirs();
        this._base = base;
        this._formatter = formatter;
    }

    public void append(Event e) {
        try {
            this._check();
            this._printStream.write(this._formatter.format(e).getBytes("utf8"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void _check() throws IOException {
        if (this._printStream != null && System.currentTimeMillis() < this._nextSwitch) {
            return;
        }
        if (this._printStream != null) {
            this._printStream.close();
        }
        JSDate now = new JSDate().roundDay();
        this._nextSwitch = now.getTime() + 86400000L;
        String name = this._base + "." + now.format("yyyy-MM-dd");
        File f = new File(this._dir, name);
        this._printStream = new PrintStream(new FileOutputStream(f, true));
    }
}

