/*
 * Decompiled with CFR 0.152.
 */
package ed.lang;

import ed.lang.WatchableRequest;
import ed.log.Logger;
import ed.util.Config;
import ed.util.ThreadUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Vector;

public class WatchableRequestMonitor
extends Thread {
    public static final long SLEEP_TIME = 200L;
    private static WatchableRequestMonitor _instance;
    private final List<Watched> _watched = new Vector<Watched>();
    private final Logger _logger = Logger.getLogger("requestmonitor");
    private final long _maxAllowedTime;
    private final long _normalAllowedTime;
    private final long _memoryWarn;

    public static synchronized WatchableRequestMonitor getInstance() {
        if (_instance == null) {
            _instance = new WatchableRequestMonitor();
        }
        return _instance;
    }

    public WatchableRequestMonitor() {
        this("REQUEST");
    }

    public WatchableRequestMonitor(String configPrefix) {
        this(Config.get().getLong(configPrefix + ".TIMEOUT.MIN", 45000L), Config.get().getLong(configPrefix + ".TIMEOUT.MAX", 300000L), Config.get().getLong(configPrefix + ".MEMORY.WARN", 0xA00000L));
    }

    public WatchableRequestMonitor(int normalSeconds, int megabytes) {
        this(1000 * normalSeconds, 6000 * normalSeconds, 0x100000 * megabytes);
    }

    public WatchableRequestMonitor(long maxAllowedTime, long normalAllowedTime, long memoryWarn) {
        super("WatchableRequestMonitor");
        this._maxAllowedTime = maxAllowedTime;
        this._normalAllowedTime = normalAllowedTime;
        this._memoryWarn = memoryWarn;
        this.setDaemon(true);
        this.start();
    }

    public void watch(WatchableRequest request) {
        if (request.canBeLong()) {
            return;
        }
        this._watched.add(new Watched(request, Thread.currentThread()));
    }

    public void run() {
        while (true) {
            ThreadUtil.sleep(200L);
            try {
                this.doPass();
                continue;
            }
            catch (Exception e) {
                this._logger.error("couldn't do a pass", e);
                continue;
            }
            break;
        }
    }

    private void doPass() {
        long now = System.currentTimeMillis();
        for (int i = 0; i < this._watched.size(); ++i) {
            Watched w = this._watched.get(i);
            if (w.done()) {
                this._watched.remove(i);
                --i;
                continue;
            }
            if (!w.needToKill(now)) continue;
            w.kill();
        }
    }

    class Watched {
        private int _bonuses = 0;
        private boolean _killAttempted = false;
        final WeakReference<WatchableRequest> _request;
        final Thread _thread;
        final long _start = System.currentTimeMillis();

        Watched(WatchableRequest request, Thread thread) {
            this._request = new WeakReference<WatchableRequest>(request);
            this._thread = thread;
        }

        boolean done() {
            WatchableRequest request = (WatchableRequest)this._request.get();
            if (request == null) {
                return true;
            }
            return request.isDone();
        }

        boolean needToKill(long now) {
            WatchableRequest request = (WatchableRequest)this._request.get();
            if (request == null) {
                return false;
            }
            return this.runningTooLong(request, now) || this.usingTooMuchMemory(request, now);
        }

        boolean usingTooMuchMemory(WatchableRequest request, long now) {
            long elapsed = now - this._start;
            if (elapsed < 600L) {
                return false;
            }
            long size = request.approxSize();
            if (size > WatchableRequestMonitor.this._memoryWarn) {
                WatchableRequestMonitor.this._logger.warn(request.debugName() + " using " + size + " memory");
            }
            return false;
        }

        boolean runningTooLong(WatchableRequest request, long now) {
            long elapsed;
            Thread.State state = this._thread.getState();
            if (state == Thread.State.BLOCKED || state == Thread.State.WAITING) {
                ++this._bonuses;
            }
            if ((elapsed = now - this._start) > WatchableRequestMonitor.this._maxAllowedTime) {
                return true;
            }
            if (elapsed < WatchableRequestMonitor.this._normalAllowedTime) {
                return false;
            }
            return (elapsed -= (long)this._bonuses * 200L) > WatchableRequestMonitor.this._normalAllowedTime;
        }

        void kill() {
            WatchableRequest request = (WatchableRequest)this._request.get();
            if (request == null) {
                return;
            }
            if (!this._killAttempted) {
                WatchableRequestMonitor.this._logger.error("killing : " + request);
            }
            this._killAttempted = true;
            request.getScope().setToThrow(new RuntimeException("running too long " + (System.currentTimeMillis() - this._start) + " ms"));
            this._thread.interrupt();
        }
    }
}

