/*
 * Decompiled with CFR 0.152.
 */
package ed.lang;

import ed.lang.StackTraceFixer;
import ed.util.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceHolder {
    public static final boolean RAW_EXCPETIONS = Config.get().getBoolean("RAWE");
    public static final boolean DEBUG = Boolean.getBoolean("DEBUG.ST");
    private static final StackTraceHolder INSTANCE = new StackTraceHolder();
    final Map<String, StackTraceFixer> _fixers = Collections.synchronizedMap(new HashMap());
    final Map<String, StackTraceFixer> _packs = Collections.synchronizedMap(new TreeMap());
    final Map<String, StackTraceFixer> _fileexts = Collections.synchronizedMap(new HashMap());

    public static final StackTraceHolder getInstance() {
        return INSTANCE;
    }

    private StackTraceHolder() {
    }

    public void setPackage(String pack, StackTraceFixer fixer) {
        this._packs.put(pack, fixer);
    }

    public void setFileType(String ext, StackTraceFixer fixer) {
        this._fileexts.put(ext, fixer);
    }

    public void set(String fullName, StackTraceFixer fixer) {
        if (DEBUG) {
            System.out.println("set [" + fullName + "] " + fixer);
        }
        this._fixers.put(fullName, fixer);
    }

    List<StackTraceFixer> getRelevant(StackTraceElement element) {
        int idx;
        String fn;
        LinkedList<StackTraceFixer> l = new LinkedList<StackTraceFixer>(){

            @Override
            public boolean add(StackTraceFixer f) {
                if (f == null) {
                    return false;
                }
                return super.add(f);
            }
        };
        String cn = element.getClassName();
        if (DEBUG) {
            System.out.println("get [" + cn + "]");
        }
        l.add(this._fixers.get(cn));
        int idx2 = cn.indexOf("$");
        if (idx2 > 0) {
            String s = cn.substring(0, idx2);
            l.add(this._fixers.get(s));
        }
        if ((idx2 = cn.lastIndexOf(".")) > 0) {
            String p = cn.substring(0, idx2);
            l.add(this._packs.get(p));
        }
        if ((fn = element.getFileName()) != null && (idx = fn.lastIndexOf(".")) > 0) {
            String ext = fn.substring(idx + 1);
            l.add(this._fileexts.get(ext));
        }
        if (l.size() == 0) {
            return null;
        }
        return l;
    }

    public StackTraceElement fix(StackTraceElement element) {
        if (RAW_EXCPETIONS) {
            return element;
        }
        if (element == null) {
            return null;
        }
        block0: while (true) {
            List<StackTraceFixer> fixers;
            if ((fixers = this.getRelevant(element)) == null) {
                return element;
            }
            for (StackTraceFixer f : fixers) {
                if (!f.removeSTElement(element)) continue;
                return null;
            }
            for (StackTraceFixer f : fixers) {
                StackTraceElement n = f.fixSTElement(element);
                if (n == null || n == element) continue;
                if (DEBUG) {
                    System.out.println(element + " -->> " + n);
                }
                element = n;
                continue block0;
            }
            break;
        }
        return element;
    }

    public void fix(Throwable t) {
        this.fix(t, true);
    }

    public void fix(Throwable t, boolean recurse) {
        if (t instanceof NoFix) {
            return;
        }
        while (t != null) {
            this._fix(t);
            if (!recurse) break;
            t = t.getCause();
        }
    }

    private void _fix(Throwable t) {
        if (t == null) {
            return;
        }
        if (RAW_EXCPETIONS) {
            return;
        }
        boolean removeThings = false;
        boolean changed = false;
        StackTraceElement[] stack = t.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement n;
            StackTraceElement element = stack[i];
            if (element == null || (n = this.fix(element)) == element) continue;
            stack[i] = n;
            changed = true;
            if (n != null) continue;
            removeThings = true;
        }
        if (removeThings) {
            changed = true;
            ArrayList<StackTraceElement> lst = new ArrayList<StackTraceElement>();
            for (StackTraceElement s : stack) {
                if (s == null) continue;
                lst.add(s);
            }
            stack = new StackTraceElement[lst.size()];
            for (int i = 0; i < stack.length; ++i) {
                stack[i] = (StackTraceElement)lst.get(i);
            }
        }
        if (changed) {
            t.setStackTrace(stack);
        }
    }

    public static interface NoFix {
    }
}

