/*
 * Decompiled with CFR 0.152.
 */
package ed.lang;

import ed.lang.ReflectionVisitor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionWalker {
    final ReflectionVisitor _visitor;

    public ReflectionWalker(ReflectionVisitor visitor) {
        this._visitor = visitor;
    }

    public void walk(Object start) {
        if (start == null) {
            return;
        }
        LinkedList<Object> togo = new LinkedList<Object>();
        togo.add(start);
        while (!togo.isEmpty()) {
            int i;
            Class<?> c;
            Object o = togo.removeLast();
            if (o == null || !this._visitor.visit(o, c = o.getClass())) continue;
            if (c.isArray()) {
                int length = Array.getLength(o);
                for (i = 0; i < length; ++i) {
                    if (!this._visitor.follow(o, c, null)) continue;
                    togo.add(Array.get(o, i));
                }
            }
            Field[] fields = c.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                if (!this._visitor.follow(o, c, fields[i])) continue;
                try {
                    fields[i].setAccessible(true);
                    togo.add(fields[i].get(o));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("can't access a field", e);
                }
            }
        }
    }

    public static List<Object> shortestPath(Object from, Object to) {
        ReflectionVisitor.ShortestPathFinder spf = new ReflectionVisitor.ShortestPathFinder(to);
        ReflectionWalker walker = new ReflectionWalker(spf);
        walker.walk(from);
        return null;
    }
}

