/*
 * Decompiled with CFR 0.152.
 */
package ed.lang;

import ed.js.JSON;
import java.util.HashMap;

public class ProfilingTracker {
    final String _name;
    private final FrameSet _root = new FrameSet();
    private static final ThreadLocal<ProfilingTracker> _threadLocal = new ThreadLocal();

    public static void tlGotTime(String name, long time, long size) {
        ProfilingTracker.tlGotTime(name, time, size, null);
    }

    public static void tlGotTime(String name, long time, long size, Object last) {
        ProfilingTracker pt = ProfilingTracker.getThreadLocal();
        if (pt == null) {
            return;
        }
        pt.gotTime(name, time, size, last);
    }

    public ProfilingTracker(String name) {
        this._name = name;
    }

    public void makeThreadLocal() {
        _threadLocal.set(this);
    }

    public static ProfilingTracker getThreadLocal() {
        return _threadLocal.get();
    }

    public static void resetThreadLocal() {
        _threadLocal.set(null);
    }

    public void gotTime(String name, long time, long size) {
        this.gotTime(name, time, size, null);
    }

    public void gotTime(String name, long time, long size, Object last) {
        this._root.inc(name, time, size, last);
    }

    public void push(String name) {
    }

    public void pop() {
    }

    String serialize(Object o) {
        try {
            String s = JSON.serialize((Object)o);
            s = s.replaceAll("[\r\n\\s]+", " ").replace('\\', ' ');
            return s;
        }
        catch (Exception e) {
            return "NOJSON";
        }
    }

    public String toString(String spacer, String eol) {
        StringBuilder buf = new StringBuilder();
        buf.append(this._name).append(eol);
        this._root.toString(buf, 1, spacer, eol);
        return buf.toString();
    }

    public String toHtml() {
        return this.toString("&nbsp;&nbsp;", "<br>");
    }

    public String toString() {
        return this.toString("  ", "\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FrameSet
    extends HashMap<String, Frame> {
        FrameSet() {
        }

        void inc(String name, long t, long s, Object last) {
            String next = null;
            if (name == null && last != null) {
                name = ProfilingTracker.this.serialize(last);
                last = null;
            } else {
                int idx = name.indexOf(".");
                if (idx > 0) {
                    next = name.substring(idx + 1);
                    name = name.substring(0, idx);
                }
            }
            Frame f = (Frame)this.get(name);
            if (f == null) {
                f = new Frame(name);
                this.put(name, f);
            }
            f.inc(next, t, s, last);
        }

        public StringBuilder toString(StringBuilder buf, int level, String spacer, String eol) {
            for (Frame f : this.values()) {
                f.toString(buf, level, spacer, eol);
            }
            return buf;
        }
    }

    class Frame {
        final String _name;
        final FrameSet _children;
        long _time;
        long _size;
        int _num;

        Frame(String name) {
            this._children = new FrameSet();
            this._time = 0L;
            this._size = 0L;
            this._name = name;
        }

        void inc(String name, long t, long size, Object last) {
            this.inc(t, size);
            if (name != null) {
                this._children.inc(name, t, size, last);
            } else if (last != null) {
                this._children.inc(null, t, size, last);
            }
        }

        void inc(long t, long s) {
            this._time += t;
            this._size += s;
            ++this._num;
        }

        void toString(StringBuilder buf, int level, String spacer, String eol) {
            for (int i = 0; i < level; ++i) {
                buf.append(spacer);
            }
            buf.append(this._name).append(" num:").append(this._num).append(" time:").append(this._time).append(" size:").append(this._size).append(eol);
            this._children.toString(buf, level + 1, spacer, eol);
        }
    }
}

