/*
 * Decompiled with CFR 0.152.
 */
package ed.lang;

import ed.js.JS;

public abstract class Language {
    final String _name;
    private static final Language _js = new JS();

    protected Language(String name) {
        this._name = name;
    }

    public boolean isComplete(String code) {
        return true;
    }

    public String toString() {
        return this._name;
    }

    public static Language find(String file) {
        return Language.find(file, false);
    }

    public static Language find(String file, boolean errorOnNoMatch) {
        int idx = file.lastIndexOf(".");
        String extension = idx >= 0 ? file.substring(idx + 1) : file;
        if (extension.equals("js") || extension.equals("jxp")) {
            return Language.JS();
        }
        if (errorOnNoMatch) {
            throw new RuntimeException("no language for [" + extension + "]");
        }
        return Language.JS();
    }

    public static Language JS() {
        return _js;
    }
}

