/*
 * Decompiled with CFR 0.152.
 */
package ed.io;

import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls5;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysExec
extends JSFunctionCalls5 {
    public static int getPID(Process p) {
        for (Field f : p.getClass().getDeclaredFields()) {
            if (f.getType() != Integer.TYPE || !f.getName().equals("pid")) continue;
            try {
                f.setAccessible(true);
                return f.getInt(p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static String[] envMapToArray(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        String[] arr = new String[map.size()];
        int pos = 0;
        for (String name : map.keySet()) {
            String val = map.get(name);
            if (val == null) {
                val = "";
            }
            arr[pos++] = name + "=" + val;
        }
        return arr;
    }

    public static int waitFor(Process p, long timeout) {
        return SysExec.waitFor(p, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitFor(Process p, final long timeout, boolean forceDestroy) {
        final boolean[] going = new boolean[]{true};
        final Thread main = Thread.currentThread();
        Thread t = new Thread(){

            public void run() {
                try {
                    1.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (going[0]) {
                    main.interrupt();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        try {
            int n = p.waitFor();
            return n;
        }
        catch (InterruptedException ie) {
            if (forceDestroy) {
                p.destroy();
            }
            int n = 143;
            return n;
        }
        finally {
            going[0] = false;
        }
    }

    public static String[] fix(String s) {
        int i;
        if (s == null) {
            return new String[0];
        }
        String[] base = s.split("\\s+");
        ArrayList<String> fixed = new ArrayList<String>();
        boolean changed = false;
        for (i = 0; i < base.length; ++i) {
            int end;
            if (!base[i].startsWith("\"")) {
                fixed.add(base[i]);
                continue;
            }
            for (end = i; end < base.length && !base[end].endsWith("\""); ++end) {
            }
            String foo = base[i++].substring(1);
            while (i <= end && i < base.length) {
                foo = foo + " " + base[i];
                ++i;
            }
            --i;
            if (foo.endsWith("\"")) {
                foo = foo.substring(0, foo.length() - 1);
            }
            fixed.add(foo);
            changed = true;
        }
        if (changed) {
            System.out.println(fixed);
            base = new String[fixed.size()];
            for (i = 0; i < fixed.size(); ++i) {
                base[i] = (String)fixed.get(i);
            }
        }
        return base;
    }

    public static Result exec(String cmdString) {
        return SysExec.exec(cmdString, null, null, null, null, null);
    }

    public static Result exec(String cmdString, String[] env, File procDir, String toSend) {
        return SysExec.exec(cmdString, env, procDir, toSend, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result exec(String cmdString, String[] env, File procDir, String toSend, final JSObject handler, final Scope scope) {
        if (handler != null && handler.get((Object)"in") != null) {
            throw new RuntimeException("can't handle 'in' handler yet");
        }
        String[] cmd = SysExec.fix(cmdString);
        try {
            final Process p = Runtime.getRuntime().exec(cmd, env, procDir);
            if (toSend != null) {
                OutputStream out = p.getOutputStream();
                out.write(toSend.getBytes());
                out.close();
            }
            final Result res = new Result();
            final IOException[] threadException = new IOException[1];
            Thread a = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Result result = res;
                        synchronized (result) {
                            res.setErr(SysExec._handleStream(scope, p.getErrorStream(), handler, "err"));
                        }
                    }
                    catch (IOException e) {
                        threadException[0] = e;
                    }
                }
            };
            a.start();
            Result result = res;
            synchronized (result) {
                res.setOut(SysExec._handleStream(scope, p.getInputStream(), handler, "out"));
            }
            a.join();
            if (threadException[0] != null) {
                throw threadException[0];
            }
            res.exitValue(p.waitFor());
            return res;
        }
        catch (Exception e) {
            throw new JSException((Object)e.toString(), (Throwable)e);
        }
    }

    static String _handleStream(Scope scope, InputStream rawIn, JSObject handlers, String type) throws IOException {
        String line;
        Object foo;
        JSFunction h = null;
        if (handlers != null && (foo = handlers.get((Object)type)) instanceof JSFunction) {
            h = (JSFunction)foo;
        }
        if (h != null && scope == null) {
            throw new RuntimeException("hanve handler for '" + type + "' but no scope");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(rawIn));
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null) {
            if (h != null) {
                h.call(scope, (Object)line);
            }
            buf.append(line).append("\n");
        }
        return buf.toString();
    }

    public Object call(Scope scope, Object o, Object toSendObj, Object envObj, Object pathObj, Object handlers, Object[] extra) {
        if (o == null) {
            return null;
        }
        File root = scope.getRoot();
        if (root == null) {
            root = new File("./");
        }
        String[] env = new String[]{};
        String toSend = null;
        if (toSendObj != null) {
            toSend = toSendObj.toString();
        }
        if (envObj instanceof JSObject) {
            JSObject foo = (JSObject)envObj;
            env = new String[foo.keySet().size()];
            int pos = 0;
            for (String name : foo.keySet()) {
                Object val = foo.get((Object)name);
                if (val == null) {
                    val = "";
                }
                env[pos++] = name + "=" + val.toString();
            }
        }
        File procDir = root;
        if (pathObj instanceof JSString) {
            procDir = new File(root, pathObj.toString());
        }
        return SysExec.exec(o.toString(), env, procDir, toSend, handlers instanceof JSObject ? (JSObject)handlers : null, scope);
    }

    public static class Result
    extends JSObjectBase {
        void setOut(String s) {
            this.set("out", s);
        }

        void setErr(String s) {
            this.set("err", s);
        }

        void exitValue(int ev) {
            this.set("exitValue", ev);
        }

        public String getOut() {
            return this.get("out").toString();
        }

        public String getErr() {
            return this.get("err").toString();
        }

        public int exitValue() {
            return ((Number)this.get("exitValue")).intValue();
        }

        public String toString() {
            return "{\n\t exitValue : " + this.exitValue() + " , \n " + "\t out : " + this.getOut() + " , \n " + "\t err : " + this.getErr() + " , \n " + "}\n";
        }
    }
}

