/*
 * Decompiled with CFR 0.152.
 */
package ed;

import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class TestNGListener
extends TestListenerAdapter {
    private int _count = 0;

    public void onTestFailure(ITestResult tr) {
        this.log("F");
    }

    public void onTestSkipped(ITestResult tr) {
        this.log("S");
    }

    public void onTestSuccess(ITestResult tr) {
        this.log(".");
    }

    private void log(String string) {
        System.out.print(string);
        if (++this._count % 40 == 0) {
            System.out.println("");
        }
        System.out.flush();
    }

    public void onFinish(ITestContext context) {
        System.out.println();
        for (ITestResult r : context.getFailedTests().getAllResults()) {
            System.out.println(r);
            System.out.println("Exception : ");
            this._print(r.getThrowable());
        }
    }

    private void _print(Throwable t) {
        int otcount = 0;
        int jlrcount = 0;
        if (t == null) {
            return;
        }
        System.out.println("-" + t.toString() + "-");
        for (StackTraceElement e : t.getStackTrace()) {
            if (e.getClassName().startsWith("org.testng.")) {
                if (otcount++ != 0) continue;
                System.out.println("  " + e + " (with others of org.testng.* omitted)");
                continue;
            }
            if (e.getClassName().startsWith("java.lang.reflect.") || e.getClassName().startsWith("sun.reflect.")) {
                if (jlrcount++ != 0) continue;
                System.out.println("  " + e + " (with others of java.lang.reflect.* or sun.reflect.* omitted)");
                continue;
            }
            System.out.println("  " + e);
        }
        if (t.getCause() != null) {
            System.out.println("Caused By : ");
            this._print(t.getCause());
        }
        System.out.println();
    }
}

