/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import com.twmacinta.util.MD5;
import ed.EDFinder;
import ed.db.ByteDecoder;
import ed.db.ByteEncoder;
import ed.db.Bytes;
import ed.db.DBJSObject;
import ed.db.DBJni;
import ed.db.ObjectId;
import ed.js.JS;
import ed.js.JSDate;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSObject;
import ed.js.JSString;
import ed.js.engine.CompileOptions;
import ed.js.engine.Convert;
import ed.js.engine.Scope;
import ed.lang.WatchableRequest;
import ed.lang.WatchableRequestMonitor;
import ed.log.Logger;
import ed.util.MemUtil;
import ed.util.Pair;
import ed.util.SimplePool;
import ed.util.StringUtil;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JSHook {
    static final boolean DEBUG = false;
    public static final int NO_SCOPE = -1;
    public static final int NO_FUNCTION = -2;
    public static final int INVOKE_ERROR = -3;
    public static final int INVOKE_SUCCESS = 0;
    private static Scope _scope = null;
    static SimplePool<ByteDecoder> _setObjectPool = new SimplePool<ByteDecoder>("JSHook.scopeSetObjectPool", 10, 10){

        protected ByteDecoder createNew() {
            ByteBuffer temp = ByteBuffer.wrap(new byte[1]);
            temp.order(Bytes.ORDER);
            return new ByteDecoder(temp);
        }
    };
    private static final MD5 _myMd5 = new MD5();
    private static final Map<String, Pair<JSFunction, Long>> _functions = Collections.synchronizedMap(new HashMap());
    private static final Map<Long, JSFunction> _functionIDS = Collections.synchronizedMap(new HashMap());
    private static long _funcID = 1L;
    private static Map<Long, Scope> _scopes = Collections.synchronizedMap(new HashMap());
    static final Map<String, DBJni> _clients = Collections.synchronizedMap(new HashMap());
    static int _numInvokes = 0;
    static final ThreadLocal<JSObject> _nextArgs = new ThreadLocal();
    private static WatchableRequestMonitor _monitor;
    private static Logger _invokeLogger;
    private static CompileOptions _jsOptions;

    private static final Scope _getScope() {
        if (_scope == null) {
            _scope = Scope.newGlobal();
        }
        return _scope;
    }

    public static void init(String where) {
        EDFinder.whereIsEd = where;
    }

    public static long scopeCreate() {
        JS.JNI = true;
        Scope s = JSHook._getScope().child();
        s.setGlobal(true);
        _scopes.put(s.getId(), s);
        return s.getId();
    }

    public static boolean scopeReset(long id) {
        Scope s = _scopes.get(id);
        if (s == null) {
            return false;
        }
        s.reset();
        return true;
    }

    public static void scopeFree(long id) {
        _scopes.remove(id);
    }

    public static boolean scopeSetNumber(long id, String field, double val) {
        _scopes.get(id).set((Object)field, (Object)val);
        return true;
    }

    public static boolean scopeSetBoolean(long id, String field, boolean val) {
        _scopes.get(id).set((Object)field, (Object)val);
        return true;
    }

    public static boolean scopeSetString(long id, String field, String val) {
        _scopes.get(id).set((Object)field, (Object)val);
        return true;
    }

    public static boolean scopeSetObject(long id, String field, JSObject o) {
        if (field.equals("args")) {
            _nextArgs.set(o);
        }
        _scopes.get(id).set((Object)field, (Object)o);
        return true;
    }

    public static boolean scopeSetObject(long id, String field, ByteBuffer buf) {
        DBJSObject obj = null;
        if (buf != null) {
            buf.order(Bytes.ORDER);
            obj = new DBJSObject(buf);
        }
        return JSHook.scopeSetObject(id, field, obj);
    }

    public static boolean scopeSetThis(long id, ByteBuffer buf) {
        if (buf == null) {
            return false;
        }
        buf.order(Bytes.ORDER);
        Scope s = _scopes.get(id);
        DBJSObject obj = new DBJSObject(buf);
        s.setThis((Object)obj);
        return true;
    }

    public static boolean scopeInit(long id, ByteBuffer buf) {
        if (buf == null) {
            return false;
        }
        buf.order(Bytes.ORDER);
        Scope s = _scopes.get(id);
        DBJSObject obj = new DBJSObject(buf);
        for (String key : obj.keySet()) {
            s.set((Object)key, obj.get(key));
        }
        return true;
    }

    public static double scopeGetNumber(long id, String field) {
        Object foo = JSHook._scopeGet(id, field);
        if (foo == null) {
            return 0.0;
        }
        if (foo instanceof Number) {
            return ((Number)foo).doubleValue();
        }
        if (foo instanceof Boolean) {
            boolean b = (Boolean)foo;
            return b ? 1.0 : 0.0;
        }
        String msg = "can't get a number from a : " + foo.getClass();
        throw new RuntimeException(msg);
    }

    public static String scopeGetString(long id, String field) {
        Object o = JSHook._scopeGet(id, field);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static boolean scopeGetBoolean(long id, String field) {
        return JSInternalFunctions.JS_evalToBool((Object)JSHook._scopeGet(id, field));
    }

    public static byte scopeGetType(long id, String field) {
        return Bytes.getType(JSHook._scopeGet(id, field));
    }

    public static long scopeGuessObjectSize(long id, String field) {
        Object o = JSHook._scopeGet(id, field);
        if (o == null) {
            return 0L;
        }
        if (!(o instanceof JSObject)) {
            return 0L;
        }
        return JSHook._guessSize((JSObject)o);
    }

    public static final long _guessSize(JSObject o) {
        if (o == null) {
            return 2L;
        }
        long s = 20L;
        for (String name : o.keySet(false)) {
            s += (long)(name.length() + 12);
            Object foo = o.get((Object)name);
            if (foo == null) continue;
            if (foo instanceof Number) {
                s += 12L;
                continue;
            }
            if (foo instanceof JSString || foo instanceof String) {
                s += (long)(foo.toString().length() * 3);
                continue;
            }
            if (foo instanceof JSDate) {
                s += 12L;
                continue;
            }
            if (foo instanceof JSObject) {
                s += JSHook._guessSize((JSObject)foo);
                continue;
            }
            if (foo instanceof Boolean) {
                s += 2L;
                continue;
            }
            if (foo instanceof ObjectId) {
                s += 12L;
                continue;
            }
            System.err.println("JSHook : guessing size for : " + foo.getClass());
            s += (long)(foo.toString().length() * 10);
        }
        return s;
    }

    public static int scopeGetObject(long id, String field, ByteBuffer bb) {
        Object o = JSHook._scopeGet(id, field);
        if (o == null) {
            return 0;
        }
        if (!(o instanceof JSObject)) {
            return 0;
        }
        JSObject obj = (JSObject)o;
        ByteEncoder encoder = new ByteEncoder(bb);
        encoder.putObject(obj);
        encoder.neverUsingThisAgain();
        return bb.position();
    }

    static Object _scopeGet(long id, String field) {
        return _scopes.get(id).get(field);
    }

    public static JSFunction convertToFunction(String code) {
        String sym;
        int idx;
        code = code.trim();
        for (idx = 0; idx < code.length() && Character.isLetter(code.charAt(idx)); ++idx) {
        }
        if (idx >= code.length()) {
            throw new RuntimeException("don't know how to deal with code [" + code + "]");
        }
        String firstLine = code;
        if (firstLine.indexOf("\n") > 0) {
            firstLine = firstLine.substring(0, firstLine.indexOf("\n")).trim();
        }
        if ((sym = code.substring(0, idx)).equals("function")) {
            return Convert.makeAnon((String)code, (boolean)true, (CompileOptions)_jsOptions);
        }
        return Convert.makeAnon((String)code, (boolean)true, (CompileOptions)_jsOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long functionCreate(String code) {
        JS.JNI = true;
        String md5 = null;
        MD5 mD5 = _myMd5;
        synchronized (mD5) {
            _myMd5.Init();
            _myMd5.Update(code.toString());
            md5 = _myMd5.asHex();
        }
        Pair p = _functions.get(md5);
        if (p != null) {
            return (Long)p.second;
        }
        JSFunction f = null;
        try {
            f = JSHook.convertToFunction(code);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0L;
        }
        long id = _funcID++;
        p = new Pair((Object)f, (Object)id);
        _functions.put(md5, (Pair<JSFunction, Long>)p);
        _functionIDS.put(id, f);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int invoke(long scopeID, long functionID) {
        Scope s;
        if (++_numInvokes % 100000 == 0) {
            JSHook.printStatus(true);
        }
        if ((s = _scopes.get(scopeID)) == null) {
            return -1;
        }
        JSFunction f = _functionIDS.get(functionID);
        if (f == null) {
            return -2;
        }
        Object client = s.get("$client");
        String clientString = "db call";
        if (client != null) {
            clientString = client.toString();
            DBJni db = _clients.get(clientString);
            if (db == null) {
                db = new DBJni(clientString);
                _clients.put(clientString, db);
            }
            s.set((Object)"db", (Object)db);
        }
        JSCall call = new JSCall(s, clientString);
        JSHook.getMonitor().watch((WatchableRequest)call);
        try {
            Object ret;
            Object[] args = null;
            JSObject argsObject = _nextArgs.get();
            _nextArgs.set(null);
            if (argsObject != null) {
                int num = 0;
                while (argsObject.containsKey(String.valueOf(num))) {
                    ++num;
                }
                args = new Object[num];
                for (int i = 0; i < num; ++i) {
                    Object a;
                    args[i] = a = argsObject.get((Object)String.valueOf(i));
                }
            }
            if ((ret = f.call(s, args)) instanceof JSFunction) {
                ret = ((JSFunction)ret).call(s, null);
            }
            s.set((Object)"return", ret);
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            call.done();
            s.clearToThrow();
            _invokeLogger.error((Object)clientString, t);
            JSHook.scopeSetString(scopeID, "error", StringUtil.getStackTrace((Throwable)t));
            int n = -3;
            return n;
        }
        finally {
            call.done();
        }
    }

    static void printStatus(boolean gc) {
        System.out.println(MemUtil.getMemInfo((boolean)gc));
        System.out.println("num calls   \t " + _numInvokes);
        System.out.println("functions   \t " + _functions.size());
        System.out.println("functionIDS \t " + _functionIDS.size());
        System.out.println("scopes      \t " + _scopes.size());
        System.out.println("clients     \t " + _clients.size());
    }

    private static WatchableRequestMonitor getMonitor() {
        if (_monitor == null) {
            _monitor = new WatchableRequestMonitor(120, 10);
            _invokeLogger = Logger.getLogger((String)"db.invoke");
        }
        return _monitor;
    }

    static {
        _jsOptions = new CompileOptions().createNewScope(false).useLocalJavaVariables(false).lock();
    }

    static class JSCall
    implements WatchableRequest {
        final Scope _scope;
        final String _debugName;
        boolean _done = false;

        JSCall(Scope s, String debugName) {
            this._scope = s;
            this._debugName = debugName;
        }

        void done() {
            this._done = true;
        }

        public boolean isDone() {
            return this._done;
        }

        public Scope getScope() {
            return this._scope;
        }

        public long approxSize() {
            return 0L;
        }

        public String debugName() {
            return this._debugName;
        }

        public boolean canBeLong() {
            return false;
        }
    }
}

