/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.db.DBAddress;
import ed.db.DBApiLayer;
import ed.db.DBCollection;
import ed.db.DBJSObject;
import ed.db.DBMessage;
import ed.db.DBMessageLayer;
import ed.db.DBPort;
import ed.db.DBPortPool;
import ed.js.JSException;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.log.Logger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTCP
extends DBMessageLayer {
    static Logger _logger = Logger.getLogger((String)"DBTCP");
    static Logger _createLogger = _logger.getChild("connect");
    private DBAddress _curAddress;
    private DBPortPool _curPortPool;
    private final List<DBAddress> _allHosts;
    private final ThreadLocal<MyPort> _threadPort = new ThreadLocal<MyPort>(){

        @Override
        protected MyPort initialValue() {
            return new MyPort();
        }
    };
    private static final JSObjectBase _isMaster = new JSObjectBase();

    public DBTCP(DBAddress addr) {
        super(DBTCP._checkAddress((DBAddress)addr)._name);
        _createLogger.info((Object)addr);
        if (addr.isPaired()) {
            this._allHosts = new ArrayList<DBAddress>(addr.getPairedAddresses());
            this._validatePairs(this._allHosts);
            this._pickInitial();
            _createLogger.info((Object)("switch to paired mode : " + this._allHosts + " -> " + this._curAddress));
        } else {
            this._set(addr);
            this._allHosts = null;
        }
    }

    public DBTCP(List<DBAddress> all) {
        super(DBTCP._checkAddress(all)._name);
        this._validatePairs(all);
        this._allHosts = new ArrayList<DBAddress>(all);
        this._pickInitial();
        _createLogger.info((Object)(all + " -> " + this._curAddress));
    }

    private void _validatePairs(List<DBAddress> all) {
        String name = all.get((int)0)._name;
        for (int i = 1; i < all.size(); ++i) {
            if (all.get((int)i)._name.equals(name)) continue;
            throw new IllegalArgumentException(" names don't match [" + all.get((int)i)._name + "] != [" + name + "]");
        }
    }

    private static DBAddress _checkAddress(DBAddress addr) {
        if (addr == null) {
            throw new NullPointerException("address can't be null");
        }
        return addr;
    }

    private static DBAddress _checkAddress(List<DBAddress> addrs) {
        if (addrs == null) {
            throw new NullPointerException("addresses can't be null");
        }
        if (addrs.size() == 0) {
            throw new IllegalArgumentException("need to specify at least 1 address");
        }
        return addrs.get(0);
    }

    @Override
    public void requestStart() {
        this._threadPort.get().requestStart();
    }

    @Override
    public void requestDone() {
        this._threadPort.get().requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this._threadPort.get().requestEnsureConnection();
    }

    @Override
    protected void say(int op, ByteBuffer buf) {
        MyPort mp = this._threadPort.get();
        DBPort port = mp.get(true);
        try {
            port.say(new DBMessage(op, buf));
            mp.done(port);
        }
        catch (Exception ioe) {
            mp.error(ioe);
            this._error();
            throw new JSException((Object)"can't say something", (Throwable)ioe);
        }
    }

    @Override
    protected int call(int op, ByteBuffer out, ByteBuffer in) {
        return this._call(op, out, in, 2);
    }

    private int _call(int op, ByteBuffer out, ByteBuffer in, int retries) {
        MyPort mp = this._threadPort.get();
        DBPort port = mp.get(false);
        try {
            DBMessage a = new DBMessage(op, out);
            DBMessage b = port.call(a, in);
            mp.done(port);
            String err = this._getError(in);
            if (err != null && "not master".equals(err)) {
                this._pickCurrent();
                if (retries <= 0) {
                    throw new RuntimeException("not talking to master and retries used up");
                }
                in.position(0);
                return this._call(op, out, in, retries - 1);
            }
            return b.dataLen();
        }
        catch (Exception ioe) {
            mp.error(ioe);
            if (this._error() && retries > 0) {
                in.position(0);
                return this._call(op, out, in, retries - 1);
            }
            throw new JSException((Object)"can't call something", (Throwable)ioe);
        }
    }

    @Override
    public DBAddress getAddress() {
        return this._curAddress;
    }

    @Override
    public String getConnectPoint() {
        return this._curAddress.toString();
    }

    boolean _error() {
        if (this._allHosts != null) {
            this._pickCurrent();
        }
        return true;
    }

    String _getError(ByteBuffer buf) {
        DBApiLayer.QueryHeader header = new DBApiLayer.QueryHeader(buf, 0);
        if (header._num != 1) {
            return null;
        }
        DBJSObject obj = new DBJSObject(buf, header.headerSize());
        Object err = obj.get("$err");
        if (err == null) {
            return null;
        }
        return err.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _pickInitial() {
        assert (this._curAddress == null);
        this._pickCurrent();
        try {
            System.out.println(this._curAddress);
            DBCollection collection = this.getCollection("$cmd");
            Iterator<JSObject> i = collection.find((JSObject)_isMaster, null, 0, 1);
            if (i == null || !i.hasNext()) {
                throw new RuntimeException("no result for ismaster query?");
            }
            JSObject res = i.next();
            if (i.hasNext()) {
                throw new RuntimeException("what's going on");
            }
            int ismaster = ((Number)res.get((Object)"ismaster")).intValue();
            if (1 == ismaster) {
                return;
            }
            if (res.get((Object)"remote") == null) {
                throw new RuntimeException("remote not sent back!");
            }
            String remote = res.get((Object)"remote").toString();
            List<DBAddress> list = this._allHosts;
            synchronized (list) {
                for (DBAddress a : this._allHosts) {
                    if (!a.sameHost(remote)) continue;
                    System.out.println("remote [" + remote + "] -> [" + a + "]");
                    this._set(a);
                    return;
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"can't pick initial master, using random one", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _pickCurrent() {
        if (this._allHosts == null) {
            throw new RuntimeException("got master/slave issue but not in master/slave mode on the client side");
        }
        List<DBAddress> list = this._allHosts;
        synchronized (list) {
            Collections.shuffle(this._allHosts);
            for (int i = 0; i < this._allHosts.size(); ++i) {
                DBAddress a = this._allHosts.get(i);
                if (a == this._curAddress) continue;
                if (this._curAddress != null) {
                    _logger.info((Object)("switching from [" + this._curAddress + "] to [" + a + "]"));
                }
                this._set(a);
                return;
            }
        }
        throw new RuntimeException("couldn't find a new host to swtich too");
    }

    private boolean _set(DBAddress addr) {
        if (this._curAddress == addr) {
            return false;
        }
        this._curAddress = addr;
        this._curPortPool = DBPortPool.get(this._curAddress);
        return true;
    }

    @Override
    public String debugString() {
        StringBuilder buf = new StringBuilder(this._root);
        buf.append(" DBTCP: ");
        if (this._allHosts != null) {
            buf.append("paired : ").append(this._allHosts);
        } else {
            buf.append(this._curAddress).append(" ").append(this._curAddress._addr);
        }
        return buf.toString();
    }

    static {
        _isMaster.set((Object)"ismaster", (Object)1);
        _isMaster.lock();
    }

    class MyPort {
        DBPort _port;
        boolean _inRequest;

        MyPort() {
        }

        DBPort get(boolean keep) {
            if (this._port != null) {
                return this._port;
            }
            DBPort p = DBTCP.this._curPortPool.get();
            if (keep && this._inRequest) {
                this._port = p;
            }
            return p;
        }

        void done(DBPort p) {
            if (p != this._port) {
                DBTCP.this._curPortPool.done(p);
            }
        }

        void error(Exception e) {
            this._port = null;
            DBTCP.this._curPortPool.gotError(e);
        }

        void requestEnsureConnection() {
            if (!this._inRequest) {
                return;
            }
            if (this._port != null) {
                return;
            }
            this._port = DBTCP.this._curPortPool.get();
        }

        void requestStart() {
            this._inRequest = true;
            if (this._port != null) {
                this._port = null;
                System.err.println("ERROR.  somehow _port was not null at requestStart");
            }
        }

        void requestDone() {
            if (this._port != null) {
                DBTCP.this._curPortPool.done(this._port);
            }
            this._port = null;
            this._inRequest = false;
        }
    }
}

