/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.db.DBApiLayer;
import ed.lang.ProfilingTracker;
import java.nio.ByteBuffer;

public abstract class DBMessageLayer
extends DBApiLayer {
    DBMessageLayer(String root) {
        super(root);
    }

    protected void doInsert(ByteBuffer buf) {
        long start = System.currentTimeMillis();
        this.say(2002, buf);
        ProfilingTracker.tlGotTime((String)"db.insert", (long)(System.currentTimeMillis() - start), (long)0L);
    }

    protected void doDelete(ByteBuffer buf) {
        long start = System.currentTimeMillis();
        this.say(2006, buf);
        ProfilingTracker.tlGotTime((String)"db.delete", (long)(System.currentTimeMillis() - start), (long)0L);
    }

    protected void doUpdate(ByteBuffer buf) {
        long start = System.currentTimeMillis();
        this.say(2001, buf);
        ProfilingTracker.tlGotTime((String)"db.update", (long)(System.currentTimeMillis() - start), (long)0L);
    }

    protected void doKillCursors(ByteBuffer buf) {
        long start = System.currentTimeMillis();
        this.say(2007, buf);
        ProfilingTracker.tlGotTime((String)"db.killCursors", (long)(System.currentTimeMillis() - start), (long)0L);
    }

    protected int doQuery(ByteBuffer out, ByteBuffer in) {
        long start = System.currentTimeMillis();
        int res = this.call(2004, out, in);
        ProfilingTracker.tlGotTime((String)"db.query", (long)(System.currentTimeMillis() - start), (long)res);
        return res;
    }

    protected int doGetMore(ByteBuffer out, ByteBuffer in) {
        long start = System.currentTimeMillis();
        int res = this.call(2005, out, in);
        ProfilingTracker.tlGotTime((String)"db.getMore", (long)(System.currentTimeMillis() - start), (long)res);
        return res;
    }

    protected abstract void say(int var1, ByteBuffer var2);

    protected abstract int call(int var1, ByteBuffer var2, ByteBuffer var3);
}

