/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.db.Bytes;
import ed.db.DBAddress;
import ed.db.DBMessage;
import ed.db.DBMessageLayer;
import ed.util.SimplePool;
import java.nio.ByteBuffer;

public class DBJni
extends DBMessageLayer {
    static final BufPool _pool = new BufPool();

    DBJni(String root) {
        super(root);
    }

    public String getConnectPoint() {
        return null;
    }

    public DBAddress getAddress() {
        return null;
    }

    protected void say(int op, ByteBuffer dataOut) {
        DBMessage m = new DBMessage(op, dataOut);
        Buf b = (Buf)_pool.get();
        m.putHeader(b.out);
        b.out.put(dataOut);
        DBJni.native_say(b.out);
        _pool.done(b);
    }

    protected int call(int op, ByteBuffer dataOut, ByteBuffer dataIn) {
        DBMessage m = new DBMessage(op, dataOut);
        Buf b = (Buf)_pool.get();
        m.putHeader(b.out);
        b.out.put(dataOut);
        int len = DBJni.native_call(b.out, b.in);
        b.in.limit(len);
        if (len >= b.in.capacity()) {
            throw new RuntimeException("buffer too small");
        }
        DBMessage inMsg = new DBMessage(b.in, b.in);
        dataIn.put(b.in);
        dataIn.flip();
        _pool.done(b);
        return dataIn.limit();
    }

    public String debugString() {
        return this._root + " DBJni";
    }

    static native void native_say(ByteBuffer var0);

    static native int native_call(ByteBuffer var0, ByteBuffer var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BufPool
    extends SimplePool<Buf> {
        BufPool() {
            super("DBJni-BufPool", 20, 50);
        }

        public boolean ok(Buf b) {
            b.reset();
            return true;
        }

        protected Buf createNew() {
            return new Buf();
        }
    }

    static class Buf {
        ByteBuffer in = ByteBuffer.allocateDirect(0x500000);
        ByteBuffer out = ByteBuffer.allocateDirect(0x500000);

        Buf() {
            this.reset();
        }

        void reset() {
            this.reset(this.in);
            this.reset(this.out);
        }

        void reset(ByteBuffer buf) {
            buf.position(0);
            buf.limit(buf.capacity());
            buf.order(Bytes.ORDER);
        }
    }
}

