/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.MyAsserts;
import ed.db.ObjectId;
import ed.js.JSDate;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSRegex;
import ed.js.engine.Convert;
import ed.js.engine.Scope;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBJSObject
implements JSObject {
    static boolean DEBUG = Boolean.getBoolean("DEBUG.DBJSO");
    final ByteBuffer _buf;
    final int _offset;
    final int _end;
    private static final byte[] _cStrBuf = new byte[1024];

    DBJSObject(ByteBuffer buf) {
        this(buf, 0);
        MyAsserts.assertEquals((int)this._end, (int)this._buf.limit());
    }

    DBJSObject(ByteBuffer buf, int offset) {
        this._buf = buf;
        this._offset = offset;
        this._end = this._buf.getInt(this._offset);
    }

    public Object get(Object n) {
        Element e = this.findElement(n.toString());
        if (e == null) {
            return null;
        }
        return e.getObject();
    }

    public JSFunction getFunction(String name) {
        return JSObjectBase.getFunction((JSObject)this, (String)name);
    }

    public Object getInt(int n) {
        return this.get(String.valueOf(n));
    }

    public Object setInt(int n, Object v) {
        throw new RuntimeException("read only");
    }

    public Object set(Object n, Object v) {
        throw new RuntimeException("read only");
    }

    public Object removeField(Object n) {
        throw new RuntimeException("read only");
    }

    public boolean containsKey(String s) {
        return this.containsKey(s, true);
    }

    public boolean containsKey(String s, boolean includePrototype) {
        return this.findElement(s) != null;
    }

    public Set<String> keySet() {
        return this.keySet(true);
    }

    public Set<String> keySet(boolean includePrototype) {
        Element e;
        HashSet<String> keys = new HashSet<String>();
        ElementIter i = new ElementIter();
        while (i.hasNext() && !(e = i.next()).eoo()) {
            keys.add(e.fieldName());
        }
        return keys;
    }

    public JSFunction getConstructor() {
        return null;
    }

    public JSObject getSuper() {
        return null;
    }

    String _readCStr(int start) {
        return this._readCStr(start, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String _readCStr(int start, int[] end) {
        byte[] byArray = _cStrBuf;
        synchronized (_cStrBuf) {
            int pos = 0;
            while (this._buf.get(pos + start) > 0) {
                DBJSObject._cStrBuf[pos] = this._buf.get(pos + start);
                ++pos;
            }
            if (end != null && end.length > 0) {
                end[0] = start + pos;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new String(_cStrBuf, 0, pos);
        }
    }

    String _readJavaString(int start) {
        int size = this._buf.getInt(start) - 1;
        byte[] b = new byte[size];
        int old = this._buf.position();
        this._buf.position(start + 4);
        this._buf.get(b, 0, b.length);
        this._buf.position(old);
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(b);
        }
    }

    int _cStrLength(int start) {
        int end = start;
        while (this._buf.get(end) > 0) {
            ++end;
        }
        return 1 + (end - start);
    }

    Element findElement(String name) {
        ElementIter i = new ElementIter();
        while (i.hasNext()) {
            Element e = i.next();
            if (!e.fieldName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public String toString() {
        return "Object";
    }

    class ElementIter {
        int _pos;
        boolean _done = false;

        ElementIter() {
            this._pos = DBJSObject.this._offset + 4;
        }

        boolean hasNext() {
            return !this._done && this._pos < DBJSObject.this._buf.limit();
        }

        Element next() {
            Element e = new Element(this._pos);
            this._done = e.eoo();
            this._pos += e.size();
            return e;
        }
    }

    class Element {
        final int _start;
        final byte _type;
        final String _name;
        final int _dataStart;
        final int _size;
        Object _cached;

        Element(int start) {
            this._start = start;
            this._type = DBJSObject.this._buf.get(this._start);
            String string = this._name = this.eoo() ? "" : DBJSObject.this._readCStr(this._start + 1);
            if (DEBUG) {
                System.out.println("name [" + this._name + "] type [" + this._type + "]");
            }
            int size = 1 + this._name.length() + 1;
            this._dataStart = this._start + size;
            switch (this._type) {
                case -1: 
                case 0: 
                case 6: 
                case 10: {
                    break;
                }
                case 8: {
                    ++size;
                    break;
                }
                case 1: 
                case 9: {
                    size += 8;
                    break;
                }
                case 16: {
                    size += 4;
                    break;
                }
                case 7: {
                    size += 12;
                    break;
                }
                case 12: {
                    size += 12;
                }
                case 2: 
                case 13: 
                case 14: {
                    size += 4 + DBJSObject.this._buf.getInt(this._dataStart);
                    break;
                }
                case 3: 
                case 4: 
                case 15: {
                    size += DBJSObject.this._buf.getInt(this._dataStart);
                    break;
                }
                case 5: {
                    size += 4 + DBJSObject.this._buf.getInt(this._dataStart) + 1;
                    break;
                }
                case 11: {
                    int first = DBJSObject.this._cStrLength(this._dataStart);
                    int second = DBJSObject.this._cStrLength(this._dataStart + first);
                    size += first + second;
                    break;
                }
                default: {
                    throw new RuntimeException("can't handle type " + this._type);
                }
            }
            this._size = size;
        }

        String fieldName() {
            return this._name;
        }

        boolean eoo() {
            return this._type == 0 || this._type == -1;
        }

        int size() {
            return this._size;
        }

        Object getObject() {
            if (this._cached != null) {
                return this._cached;
            }
            switch (this._type) {
                case 1: {
                    return DBJSObject.this._buf.getDouble(this._dataStart);
                }
                case 16: {
                    return DBJSObject.this._buf.getInt(this._dataStart);
                }
                case 7: {
                    return new ObjectId(DBJSObject.this._buf.getLong(this._dataStart), DBJSObject.this._buf.getInt(this._dataStart + 8));
                }
                case 13: 
                case 14: {
                    return Convert.makeAnon((String)DBJSObject.this._readJavaString(this._dataStart));
                }
                case 15: {
                    JSFunction func = Convert.makeAnon((String)DBJSObject.this._readJavaString(this._dataStart + 4));
                    int scopeStart = this._dataStart + 4 + DBJSObject.this._buf.getInt(this._dataStart + 4) + 4;
                    DBJSObject obj = new DBJSObject(DBJSObject.this._buf, scopeStart);
                    Scope s = func.getScope(true);
                    s.putAll((JSObject)obj);
                    this._cached = func;
                    return func;
                }
                case 2: {
                    return DBJSObject.this._readJavaString(this._dataStart);
                }
                case 9: {
                    return new JSDate(DBJSObject.this._buf.getLong(this._dataStart));
                }
                case 11: {
                    int[] endPos = new int[1];
                    String first = DBJSObject.this._readCStr(this._dataStart, endPos);
                    return new JSRegex(first, DBJSObject.this._readCStr(1 + endPos[0]));
                }
                case 5: {
                    throw new RuntimeException("can't inspect binary in db");
                }
                case 8: {
                    return DBJSObject.this._buf.get(this._dataStart) > 0;
                }
                case 3: 
                case 4: {
                    return new DBJSObject(DBJSObject.this._buf, this._dataStart);
                }
                case -1: 
                case 0: 
                case 6: 
                case 10: {
                    return null;
                }
            }
            throw new RuntimeException("can't decode type " + this._type);
        }
    }
}

