/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.TestCase;
import ed.db.ByteDecoder;
import ed.db.ByteEncoder;
import ed.db.ObjectId;
import ed.js.JSArray;
import ed.js.JSDate;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSRegex;
import java.net.URLDecoder;
import org.testng.annotations.Test;

public class ByteTest
extends TestCase {
    @Test(groups={"basic"})
    public void testObject1() {
        ByteEncoder encoder = ByteEncoder.get();
        JSObjectBase o = new JSObjectBase();
        o.set((Object)"eliot", (Object)"horowitz");
        o.set((Object)"num", (Object)517);
        encoder.putObject((JSObject)o);
        encoder.flip();
        ByteDecoder decoder = new ByteDecoder(encoder._buf);
        JSObject read = decoder.readObject();
        ByteTest.assertEquals((String)"horowitz", (Object)read.get((Object)"eliot").toString());
        ByteTest.assertEquals((Object)517.0, (Object)((Integer)read.get((Object)"num")).doubleValue());
        ByteTest.assertEquals((int)encoder._buf.limit(), (int)encoder._buf.position());
    }

    @Test(groups={"basic"})
    public void testString() throws Exception {
        ByteEncoder encoder = ByteEncoder.get();
        String eliot = URLDecoder.decode("horowitza%C3%BCa", "UTF-8");
        JSObjectBase o = new JSObjectBase();
        o.set((Object)"eliot", (Object)eliot);
        o.set((Object)"num", (Object)517);
        encoder.putObject((JSObject)o);
        encoder.flip();
        ByteDecoder decoder = new ByteDecoder(encoder._buf);
        JSObject read = decoder.readObject();
        ByteTest.assertEquals((String)eliot, (Object)read.get((Object)"eliot").toString());
        ByteTest.assertEquals((Object)517.0, (Object)((Integer)read.get((Object)"num")).doubleValue());
        ByteTest.assertEquals((int)encoder._buf.limit(), (int)encoder._buf.position());
    }

    @Test(groups={"basic"})
    public void testObject2() {
        ByteEncoder encoder = ByteEncoder.get();
        JSObjectBase o = new JSObjectBase();
        o.set((Object)"eliot", (Object)"horowitz");
        o.set((Object)"num", (Object)517.3);
        o.set((Object)"z", (Object)"y");
        o.set((Object)"asd", null);
        JSObjectBase o2 = new JSObjectBase();
        o2.set((Object)"a", (Object)"b");
        o2.set((Object)"b", (Object)"a");
        o.set((Object)"next", (Object)o2);
        encoder.putObject((JSObject)o);
        encoder.flip();
        ByteDecoder decoder = new ByteDecoder(encoder._buf);
        JSObject read = decoder.readObject();
        ByteTest.assertEquals((String)"horowitz", (Object)read.get((Object)"eliot").toString());
        ByteTest.assertEquals((Object)517.3, (Object)((Double)read.get((Object)"num")));
        ByteTest.assertEquals((String)"b", (Object)((JSObject)read.get((Object)"next")).get((Object)"a").toString());
        ByteTest.assertEquals((String)"a", (Object)((JSObject)read.get((Object)"next")).get((Object)"b").toString());
        ByteTest.assertEquals((String)"y", (Object)read.get((Object)"z").toString());
        ByteTest.assertEquals((int)o.keySet().size(), (int)read.keySet().size());
        ByteTest.assertEquals((int)encoder._buf.limit(), (int)encoder._buf.position());
    }

    @Test(groups={"basic"})
    public void testArray1() {
        ByteEncoder encoder = ByteEncoder.get();
        JSObjectBase o = new JSObjectBase();
        o.set((Object)"eliot", (Object)"horowitz");
        o.set((Object)"num", (Object)517);
        o.set((Object)"z", (Object)"y");
        o.set((Object)"asd", null);
        o.set((Object)"myt", (Object)true);
        o.set((Object)"myf", (Object)false);
        JSArray a = new JSArray();
        a.add((Object)"A");
        a.add((Object)"B");
        a.add((Object)"C");
        o.set((Object)"a", (Object)a);
        o.set((Object)"d", (Object)new JSDate());
        o.set((Object)"r", (Object)new JSRegex("\\d+", "i"));
        encoder.putObject((JSObject)o);
        encoder.flip();
        ByteDecoder decoder = new ByteDecoder(encoder._buf);
        JSObject read = decoder.readObject();
        ByteTest.assertEquals((String)"horowitz", (Object)read.get((Object)"eliot").toString());
        ByteTest.assertEquals((int)517, (int)((Integer)read.get((Object)"num")));
        ByteTest.assertEquals((String)"y", (Object)read.get((Object)"z").toString());
        ByteTest.assertEquals((int)o.keySet().size(), (int)read.keySet().size());
        ByteTest.assertEquals((int)3, (int)a.size());
        ByteTest.assertEquals((int)a.size(), (int)((JSArray)read.get((Object)"a")).size());
        ByteTest.assertEquals((String)"A", (Object)((JSArray)read.get((Object)"a")).get(0).toString());
        ByteTest.assertEquals((String)"B", (Object)((JSArray)read.get((Object)"a")).get(1).toString());
        ByteTest.assertEquals((String)"C", (Object)((JSArray)read.get((Object)"a")).get(2).toString());
        ByteTest.assertEquals((long)((JSDate)o.get((Object)"d")).getTime(), (long)((JSDate)read.get((Object)"d")).getTime());
        ByteTest.assertEquals((Object)true, (Object)((Boolean)o.get((Object)"myt")));
        ByteTest.assertEquals((Object)false, (Object)((Boolean)o.get((Object)"myf")));
        ByteTest.assertEquals((String)o.get((Object)"r").toString(), (Object)read.get((Object)"r").toString());
        ByteTest.assertEquals((int)encoder._buf.limit(), (int)encoder._buf.position());
    }

    @Test(groups={"basic"})
    public void testObjcetId() {
        ByteTest.assertTrue((new ObjectId().compareTo(new ObjectId()) < 0 ? 1 : 0) != 0);
        ByteTest.assertTrue((new ObjectId(0L, 0).compareTo(new ObjectId()) < 0 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        new ByteTest().runConsole();
    }
}

