/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.db.Bytes;
import ed.db.DBBase;
import ed.db.DBRef;
import ed.db.ObjectId;
import ed.js.JSArray;
import ed.js.JSBinaryData;
import ed.js.JSDate;
import ed.js.JSDict;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSRegex;
import ed.js.JSString;
import ed.js.engine.Convert;
import ed.util.SimplePool;
import ed.util.WatchedSimplePool;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;

public class ByteDecoder
extends Bytes {
    private static final int _poolSize = 60;
    private static final SimplePool<ByteDecoder> _pool = new WatchedSimplePool<ByteDecoder>("ByteDecoders", 60, -1){

        protected ByteDecoder createNew() {
            if (Bytes.D) {
                System.out.println("creating new ByteDecoder");
            }
            return new ByteDecoder();
        }

        protected long memSize(ByteDecoder d) {
            return 0x600400L;
        }
    };
    private final CharsetDecoder _decoder = _utf8.newDecoder();
    private final byte[] _namebuf = new byte[524288];
    ByteBuffer _buf;
    private final boolean _private;
    String _ns;
    DBBase _base;
    private JSFunction _constructor;

    protected static ByteDecoder get(DBBase base, String ns, JSFunction cons) {
        ByteDecoder bd = (ByteDecoder)_pool.get();
        bd.reset();
        bd._base = base;
        bd._ns = ns;
        bd._constructor = cons;
        return bd;
    }

    protected void done() {
        this._constructor = null;
        _pool.done((Object)this);
    }

    public ByteDecoder(ByteBuffer buf) {
        this.reset(buf);
        this._private = false;
    }

    private ByteDecoder() {
        this._buf = ByteBuffer.allocateDirect(0x500000);
        this._private = true;
        this.reset();
    }

    public void reset(ByteBuffer buf) {
        if (this._private) {
            throw new RuntimeException("can't reset private ByteDecoder");
        }
        this._buf = buf;
        if (this._buf.order() != Bytes.ORDER) {
            throw new RuntimeException("this is not correct");
        }
    }

    void reset() {
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
        this._buf.order(Bytes.ORDER);
    }

    public JSObject readObject() {
        if (this._buf.position() >= this._buf.limit()) {
            return null;
        }
        int start = this._buf.position();
        int len = this._buf.getInt();
        JSObject created = null;
        if (created == null) {
            created = this._create(this._constructor);
        }
        while (this.decodeNext(created, null, this._constructor) > 1) {
        }
        if (this._buf.position() - start != len) {
            throw new RuntimeException("lengths don't match " + (this._buf.position() - start) + " != " + len);
        }
        return created;
    }

    private JSObject _create(JSFunction cons) {
        if (cons == null) {
            return new JSDict();
        }
        JSObject o = cons.newOne();
        if (o instanceof JSObjectBase) {
            ((JSObjectBase)o).setConstructor(cons, true);
        }
        return o;
    }

    protected int decodeNext(JSObject o) {
        return this.decodeNext(o, null, null);
    }

    protected int decodeNext(JSObject o, JSFunction embedCons, JSFunction myCons) {
        int start = this._buf.position();
        byte type = this._buf.get();
        if (type == 0) {
            return 1;
        }
        String name = this.readCStr();
        JSArray created = null;
        switch (type) {
            case 10: {
                o.set((Object)name, null);
                break;
            }
            case 8: {
                o.set((Object)name, (Object)(this._buf.get() > 0 ? 1 : 0));
                break;
            }
            case 1: {
                double val = this._buf.getDouble();
                o.set((Object)name, (Object)val);
                break;
            }
            case 16: {
                o.set((Object)name, (Object)this._buf.getInt());
                break;
            }
            case 2: 
            case 14: {
                int size = this._buf.getInt() - 1;
                this._buf.get(this._namebuf, 0, size);
                try {
                    String raw = new String(this._namebuf, 0, size, "UTF-8");
                    if (type == 14) {
                        o.set((Object)name, (Object)new JSString.Symbol(raw));
                    } else {
                        o.set((Object)name, (Object)new JSString(raw));
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RuntimeException("impossible", uee);
                }
                this._buf.get();
                break;
            }
            case 7: {
                o.set((Object)name, (Object)new ObjectId(this._buf.getLong(), this._buf.getInt()));
                break;
            }
            case 12: {
                int stringSize = this._buf.getInt();
                String ns = this.readCStr();
                ObjectId theOID = new ObjectId(this._buf.getLong(), this._buf.getInt());
                o.set((Object)name, (Object)new DBRef(o, name, this._base, ns, theOID));
                break;
            }
            case 9: {
                o.set((Object)name, (Object)new JSDate(this._buf.getLong()));
                break;
            }
            case 11: {
                o.set((Object)name, (Object)new JSRegex(this.readCStr(), this.readCStr()));
                break;
            }
            case 5: {
                o.set((Object)name, this.parseBinary());
                break;
            }
            case 13: {
                try {
                    this._buf.getInt();
                    String theCode = this.readCStr();
                    JSFunction theFunc = Convert.makeAnon((String)theCode);
                    o.set((Object)name, (Object)theFunc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                if (created == null) {
                    created = new JSArray();
                }
            }
            case 3: {
                Object maybe;
                Object holder;
                int embeddedSize = this._buf.getInt();
                if (created == null) {
                    created = this._create(embedCons);
                }
                JSFunction nextEmebedCons = null;
                if (o.get((Object)name) != null) {
                    created = (JSObject)o.get((Object)name);
                    Object maybe2 = created.get((Object)"_dbCons");
                    if (maybe2 instanceof JSFunction) {
                        nextEmebedCons = (JSFunction)maybe2;
                    }
                    if (embedCons == null) {
                        embedCons = created.getConstructor();
                    }
                }
                if (myCons != null && nextEmebedCons == null && (holder = myCons.get((Object)"_dbCons")) instanceof JSObject && (maybe = ((JSObject)holder).get((Object)name)) instanceof JSFunction) {
                    nextEmebedCons = (JSFunction)maybe;
                }
                while (this.decodeNext((JSObject)created, nextEmebedCons, embedCons) > 1) {
                }
                o.set((Object)name, (Object)created);
                break;
            }
            default: {
                throw new RuntimeException("can't handle : " + type);
            }
        }
        return this._buf.position() - start;
    }

    Object parseBinary() {
        int totalLen = this._buf.getInt();
        byte bType = this._buf.get();
        switch (bType) {
            case 2: {
                int len = this._buf.getInt();
                if (D) {
                    System.out.println("got binary of size : " + len);
                }
                byte[] data = new byte[len];
                this._buf.get(data);
                return new JSBinaryData.ByteArray(data);
            }
        }
        throw new RuntimeException("can't handle binary type : " + bType);
    }

    private String readCStr() {
        byte b;
        int pos = 0;
        while ((b = this._buf.get()) != 0) {
            this._namebuf[pos++] = b;
        }
        return new String(this._namebuf, 0, pos);
    }

    int getInt() {
        return this._buf.getInt();
    }

    long getLong() {
        return this._buf.getLong();
    }

    boolean more() {
        return this._buf.position() < this._buf.limit();
    }

    long remaining() {
        return this._buf.remaining();
    }

    void doneReading(int len) {
        this._buf.position(len);
        this._buf.flip();
    }
}

