/*
 * Decompiled with CFR 0.152.
 */
package ed.ext.org.mozilla.javascript;

import ed.ext.org.mozilla.classfile.ClassFileWriter;
import ed.ext.org.mozilla.javascript.Callable;
import ed.ext.org.mozilla.javascript.Context;
import ed.ext.org.mozilla.javascript.GeneratedClassLoader;
import ed.ext.org.mozilla.javascript.Scriptable;
import ed.ext.org.mozilla.javascript.SecurityController;
import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.WeakHashMap;

public class PolicySecurityController
extends SecurityController {
    private static final byte[] secureCallerImplBytecode = PolicySecurityController.loadBytecode();
    private static final Map callers = new WeakHashMap();

    public GeneratedClassLoader createClassLoader(final ClassLoader parent, final Object securityDomain) {
        return (Loader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Loader(parent, (CodeSource)securityDomain);
            }
        });
    }

    public Object getDynamicSecurityDomain(Object securityDomain) {
        return securityDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callWithDomain(Object securityDomain, final Context cx, Callable callable, Scriptable scope, Scriptable thisObj, Object[] args) {
        SecureCaller caller;
        WeakHashMap classLoaderMap;
        final ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cx.getApplicationClassLoader();
            }
        });
        final CodeSource codeSource = (CodeSource)securityDomain;
        Map map = callers;
        synchronized (map) {
            classLoaderMap = (WeakHashMap)callers.get(codeSource);
            if (classLoaderMap == null) {
                classLoaderMap = new WeakHashMap();
                callers.put(codeSource, classLoaderMap);
            }
        }
        WeakHashMap weakHashMap = classLoaderMap;
        synchronized (weakHashMap) {
            SoftReference ref = (SoftReference)classLoaderMap.get(classLoader);
            caller = ref != null ? (SecureCaller)ref.get() : null;
            if (caller == null) {
                try {
                    caller = (SecureCaller)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Loader loader = new Loader(classLoader, codeSource);
                            Class c = loader.defineClass(SecureCaller.class.getName() + "Impl", secureCallerImplBytecode);
                            return c.newInstance();
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw new UndeclaredThrowableException(ex.getCause());
                }
            }
        }
        return caller.call(callable, cx, scope, thisObj, args);
    }

    private static byte[] loadBytecode() {
        String secureCallerClassName = SecureCaller.class.getName();
        ClassFileWriter cfw = new ClassFileWriter(secureCallerClassName + "Impl", secureCallerClassName, "<generated>");
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.addALoad(0);
        cfw.addInvoke(183, secureCallerClassName, "<init>", "()V");
        cfw.add(177);
        cfw.stopMethod((short)1);
        String callableCallSig = "Led.ext.org.mozilla.javascript/Context;Led.ext.org.mozilla.javascript/Scriptable;Led.ext.org.mozilla.javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;";
        cfw.startMethod("call", "(Led.ext.org.mozilla.javascript/Callable;" + callableCallSig, (short)17);
        for (int i = 1; i < 6; ++i) {
            cfw.addALoad(i);
        }
        cfw.addInvoke(185, "ed.ext.org.mozilla.javascript/Callable", "call", "(" + callableCallSig);
        cfw.add(176);
        cfw.stopMethod((short)6);
        return cfw.toByteArray();
    }

    public static abstract class SecureCaller {
        public abstract Object call(Callable var1, Context var2, Scriptable var3, Scriptable var4, Object[] var5);
    }

    private static class Loader
    extends SecureClassLoader
    implements GeneratedClassLoader {
        private final CodeSource codeSource;

        Loader(ClassLoader parent, CodeSource codeSource) {
            super(parent);
            this.codeSource = codeSource;
        }

        public Class defineClass(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length, this.codeSource);
        }

        public void linkClass(Class cl) {
            this.resolveClass(cl);
        }
    }
}

