/*
 * Decompiled with CFR 0.152.
 */
package ed.ext.org.mozilla.javascript;

import ed.ext.org.mozilla.javascript.Context;
import ed.ext.org.mozilla.javascript.IdFunctionObject;
import ed.ext.org.mozilla.javascript.IdScriptableObject;
import ed.ext.org.mozilla.javascript.JavaScriptException;
import ed.ext.org.mozilla.javascript.NativeGenerator;
import ed.ext.org.mozilla.javascript.NativeObject;
import ed.ext.org.mozilla.javascript.ScriptRuntime;
import ed.ext.org.mozilla.javascript.Scriptable;
import ed.ext.org.mozilla.javascript.ScriptableObject;
import ed.ext.org.mozilla.javascript.Undefined;

public final class NativeIterator
extends IdScriptableObject {
    private static final Object ITERATOR_TAG = new Object();
    public static final String STOP_ITERATION = "StopIteration";
    public static final String ITERATOR_PROPERTY_NAME = "__iterator__";
    private static final int Id_constructor = 1;
    private static final int Id_next = 2;
    private static final int Id___iterator__ = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private Object objectIterator;
    private boolean keyOnly;

    static void init(ScriptableObject scope, boolean sealed) {
        NativeIterator iterator = new NativeIterator();
        iterator.exportAsJSClass(3, scope, sealed);
        NativeGenerator prototype = NativeGenerator.init(scope, sealed);
        StopIteration obj = new StopIteration();
        obj.setPrototype(NativeIterator.getObjectPrototype(scope));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject();
        }
        ScriptableObject.defineProperty(scope, STOP_ITERATION, obj, 2);
    }

    private NativeIterator() {
    }

    private NativeIterator(Object objectIterator, boolean keyOnly) {
        this.objectIterator = objectIterator;
        this.keyOnly = keyOnly;
    }

    public String getClassName() {
        return "Iterator";
    }

    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 2;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "next";
                break;
            }
            case 3: {
                arity = 1;
                s = ITERATOR_PROPERTY_NAME;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(ITERATOR_TAG, id, s, arity);
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(ITERATOR_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        if (id == 1) {
            return NativeIterator.jsConstructor(cx, scope, thisObj, args);
        }
        if (!(thisObj instanceof NativeIterator)) {
            throw NativeIterator.incompatibleCallError(f);
        }
        NativeIterator iterator = (NativeIterator)thisObj;
        switch (id) {
            case 2: {
                return iterator.next(cx, scope);
            }
            case 3: {
                return thisObj;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Scriptable iterator;
        boolean keyOnly;
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            throw ScriptRuntime.typeError1("msg.no.properties", ScriptRuntime.toString(args[0]));
        }
        Scriptable obj = ScriptRuntime.toObject(scope, args[0]);
        boolean bl = keyOnly = args.length > 1 && ScriptRuntime.toBoolean(args[1]);
        if (thisObj != null && (iterator = ScriptRuntime.toIterator(cx, scope, obj, keyOnly)) != null) {
            return iterator;
        }
        Object objectIterator = ScriptRuntime.enumInit((Object)obj, cx, false);
        ScriptRuntime.setEnumNumbers(objectIterator, true);
        NativeIterator result = new NativeIterator(objectIterator, keyOnly);
        result.setPrototype(NativeIterator.getClassPrototype(scope, result.getClassName()));
        result.setParentScope(scope);
        return result;
    }

    private Object next(Context cx, Scriptable scope) {
        Boolean b = ScriptRuntime.enumNext(this.objectIterator);
        if (!b.booleanValue()) {
            Scriptable top = ScriptableObject.getTopLevelScope(scope);
            Object e = top.get(STOP_ITERATION, scope);
            throw new JavaScriptException(e, null, 0);
        }
        Object id = ScriptRuntime.enumId(this.objectIterator, cx);
        if (this.keyOnly) {
            return id;
        }
        Object value = ScriptRuntime.enumValue(this.objectIterator, cx);
        Object[] elements = new Object[]{id, value};
        return cx.newArray(scope, elements);
    }

    protected int findPrototypeId(String s) {
        int id;
        block5: {
            id = 0;
            String X = null;
            int s_length = s.length();
            if (s_length == 4) {
                X = "next";
                id = 2;
            } else if (s_length == 11) {
                X = "constructor";
                id = 1;
            } else if (s_length == 12) {
                X = ITERATOR_PROPERTY_NAME;
                id = 3;
            }
            if (X == null || X == s || X.equals(s)) break block5;
            id = 0;
        }
        return id;
    }

    static class StopIteration
    extends NativeObject {
        StopIteration() {
        }

        public String getClassName() {
            return NativeIterator.STOP_ITERATION;
        }

        public boolean hasInstance(Scriptable instance) {
            return instance instanceof StopIteration;
        }
    }
}

